/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.gconsole.services.aggregator.AgentHandle;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;
import org.lsst.ccs.gconsole.services.aggregator.MutableAgentStatusEvent;

class AgentHandleWrapper
extends AgentHandle {
    boolean usePublishedDataPath = false;

    AgentHandleWrapper(AgentInfo agentInfo) {
        super(agentInfo, new AgentStatusAggregator());
    }

    AgentStatusAggregator getStatusAggregator() {
        return this.aggregator;
    }

    MutableAgentStatusEvent readConfiguration(StatusConfigurationInfo mess) {
        MutableAgentStatusEvent event = new MutableAgentStatusEvent(this.getStatusAggregator(), (StatusMessage)mess);
        ConfigurationInfo config = mess.getConfigurationInfo();
        super.readConfiguration(config.getAllParameterInfo(), event);
        return event;
    }

    MutableAgentStatusEvent readTrendingData(StatusMessage mess) {
        MutableAgentStatusEvent event = new MutableAgentStatusEvent(this.getStatusAggregator(), mess);
        super.readTrendingData(mess, event);
        return event;
    }

    MutableAgentStatusEvent readState(StatusStateChangeNotification mess) {
        MutableAgentStatusEvent event = new MutableAgentStatusEvent(this.getStatusAggregator(), (StatusMessage)mess);
        super.readState(mess.getNewState(), event);
        return event;
    }

    String getAgentChannelPrevixByType(DataProviderInfo.Type type) {
        switch (type) {
            case TRENDING: 
            case MONITORING: {
                return this.AGENT_PREFIX;
            }
            case CONFIGURATION: {
                return this.CONFIG_PREFIX;
            }
            case STATE: {
                return this.STATE_PREFIX;
            }
        }
        throw new IllegalArgumentException("Could not process type: " + type);
    }

    String getPublishedDataAttribute(DataProviderInfo dc) {
        return this.usePublishedDataPath ? super.getPublishedDataAttribute(dc) : null;
    }
}

