package org.lsst.ccs.gconsole.base.filter;

import org.lsst.ccs.gconsole.annotations.services.persist.Create;

/**
 * Adapter to simplify implementing {@link AgentChannelsFilter}.
 *
 * @author onoprien
 */
abstract public class AbstractChannelsFilter implements PersistableAgentChannelsFilter  {

// -- Fields : -----------------------------------------------------------------
    
    protected Descriptor descriptor;

    
// -- Saving/restoring : -------------------------------------------------------

    @Override
    public Descriptor getDescriptor() {
        if (descriptor == null) descriptor = new Descriptor();
        return descriptor;
    }


// -- Pass-through (unfiltered) filter : ---------------------------------------
    
    static public AbstractChannelsFilter ALL = new AbstractChannelsFilter() {
        @Override
        public String getName() {return "Unfiltered";}
    };
    static public final String CREATOR_PATH_UNFILTERED = "Built-In/Basic/Unfiltered";
    
    @Create(category = AgentChannelsFilter.CATEGORY,
            name = "Unfiltered",
            path = CREATOR_PATH_UNFILTERED,
            description = "Filter that accepts all channels and leaves their paths unchanged. Use with caution - unfiltered displays contain huge numbers of data channels and may be very slow to load.")
    static public PersistableAgentChannelsFilter getUnfiltered() {
        return ALL;
    }

}
