/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.ChannelSelector;

final class AttributeSelector
implements ChannelSelector {
    private final String agentName;
    private final String[] data;

    private AttributeSelector(String agent, List<String> att) {
        this.agentName = agent;
        this.data = att.toArray(new String[att.size()]);
    }

    static AttributeSelector compile(String rawTemplate) {
        String[] ss = rawTemplate.split("&");
        ArrayList<String> out = new ArrayList<String>(ss.length * 2);
        String agentName = null;
        for (String s : ss) {
            String value;
            if (s.isEmpty()) continue;
            String[] tt = s.split("=");
            String key = tt[0];
            String string = value = tt.length == 1 ? null : tt[1];
            if ("agent.name".equals(key)) {
                agentName = value;
            }
            out.add(key);
            out.add(value);
        }
        return out.isEmpty() ? null : new AttributeSelector(agentName, out);
    }

    public String get(String key) {
        for (int i = 0; i < this.data.length; i += 2) {
            if (!this.data[i].equals(key)) continue;
            return this.data[i + 1];
        }
        return null;
    }

    @Override
    public String getAgent() {
        return this.agentName;
    }

    @Override
    public boolean match(AgentChannel channel) {
        for (int i = 0; i < this.data.length; i += 2) {
            Object v;
            String key = this.data[i];
            Object object = v = key.startsWith("agent.") ? channel.getAgent().getAgentProperty(key.substring("agent.".length())) : channel.get(key);
            if (v == null) {
                return false;
            }
            String requiredValue = this.data[i + 1];
            if (requiredValue == null || requiredValue.equals(v.toString())) continue;
            return false;
        }
        return true;
    }
}

