package org.lsst.ccs.gconsole.util.tree;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

/**
 * Node of {@link CTree}.
 * 
 * @param <T> Type of objects that can be associated with a node.
 *
 * @author onoprien
 */
public class SNode<T> extends DefaultMutableTreeNode {

// -- Fields : -----------------------------------------------------------------
    
    private final String name;

// -- Life cycle : -------------------------------------------------------------
    
    public SNode(String name) {
        this(name, null, true);
    }
    
    public SNode(String name, T userObject) {
        this(name, userObject, true);
    }
    
    public SNode(String name, T userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
        this.name = name;
    }
    
    
// -- Overriding DefaultMutableTreeNode: ---------------------------------------

// <editor-fold defaultstate="collapsed">
    @Override
    public SNode<T> getPreviousLeaf() {
        return (SNode<T>) super.getPreviousLeaf();
    }

    @Override
    public SNode<T> getNextLeaf() {
        return (SNode<T>) super.getNextLeaf();
    }

    @Override
    public SNode<T> getLastLeaf() {
        return (SNode<T>) super.getLastLeaf();
    }

    @Override
    public SNode<T> getPreviousSibling() {
        return (SNode<T>) super.getPreviousSibling();
    }

    @Override
    public SNode<T> getNextSibling() {
        return (SNode<T>) super.getNextSibling();
    }

    @Override
    public SNode<T> getChildBefore(TreeNode aChild) {
        return (SNode<T>) super.getChildBefore(aChild);
    }

    @Override
    public SNode<T> getLastChild() {
        return (SNode<T>) super.getLastChild();
    }

    @Override
    public SNode<T> getPreviousNode() {
        return (SNode<T>) super.getPreviousNode();
    }

    @Override
    public SNode<T> getNextNode() {
        return (SNode<T>) super.getNextNode();
    }

    @Override
    public SNode<T> getRoot() {
        return (SNode<T>) super.getRoot();
    }

    @Override
    public T[] getUserObjectPath() {
        return (T[]) super.getUserObjectPath();
    }

    @Override
    protected SNode<T>[] getPathToRoot(TreeNode aNode, int depth) {
        return (SNode<T>[]) super.getPathToRoot(aNode, depth);
    }

    @Override
    public SNode<T>[] getPath() {
        return (SNode<T>[]) super.getPath();
    }

    @Override
    public SNode<T> getSharedAncestor(DefaultMutableTreeNode aNode) {
        return (SNode<T>) super.getSharedAncestor(aNode);
    }

    @Override
    public void add(MutableTreeNode newChild) {
        if (!(newChild instanceof SNode)) throw new IllegalArgumentException();
        super.add(newChild);
    }

    @Override
    public T getUserObject() {
        return (T) super.getUserObject();
    }

    @Override
    public SNode<T> getChildAt(int index) {
        return (SNode<T>) super.getChildAt(index);
    }

    @Override
    public SNode<T> getParent() {
        return (SNode<T>) super.getParent();
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        if (!(newChild instanceof SNode)) throw new IllegalArgumentException();
        super.insert(newChild, childIndex);
    }

    @Override
    public String toString() {
        return name;
    }
// </editor-fold>    

// -- Extra getters : ----------------------------------------------------------
    
    public String getName() {
        return name;
    }

    public String getPathAsString() {
        return String.join("/", getPathAsStringArray());
    }
    
    public String[] getPathAsStringArray() {
        int n = getLevel();
        String[] path = new String[n];
        SNode<T> node = this;
        while (n-- > 0) {
            path[n] = node.name;
            node = node.getParent();
        }
        return path;
    }
    
    public SNode<T> getChild(String name) {
        Enumeration e = children();
        while (e.hasMoreElements()) {
            SNode<T> child = (SNode<T>) e.nextElement();
            if (name.equals(child.getName())) return child;
        }
        return null;
    }
}
