package org.lsst.ccs.gconsole.services.persist;

import java.awt.Component;

/**
 * Interface to be implemented by classes that allow users to modify a {@link Persistable} instance.
 * @param <T> Type of {@code Persistable} this editor can edit.
 *
 * @author onoprien
 */
public interface Editor<T extends Persistable> {
    
    /**
     * Takes user input and modifies the provided {@code Persistable} instance.
     * Returns {@code null} if the user cancels editing.
     * 
     * @param in Instance to be edited.
     * @param title User-interaction dialog title, or {@code null} if the default title should be used.
     * @param parent Graphical component to be use as a parent for user-interaction dialog(s).
     * @throws IllegalArgumentException If the supplied {@code Persistable} is incompatible with this {@code Editor}.
     * @throws RuntimeException If editing fails for any reason.
     * @return Modified instance. This may or may not be the same instance that was passed to this method as {@code in} parameter.
     */
    T edit(T in, String title, Component parent);
    
}
