package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.panel.DataPage;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

/**
 * Page displaying {@link MonitorView} and managed by {@link LsstMonitorPlugin}.
 *
 * @author onoprien
 */
public class MonitorPage implements Persistable {

// -- Fields : -----------------------------------------------------------------
    
    static public final String CATEGORY = "MonitorPage";
    
    private final Descriptor descriptor;
    
    private PersistableMonitorView view;
    private JComponent panel;

// -- Life cycle : -------------------------------------------------------------
    
    public MonitorPage() {
        descriptor = new Descriptor();
    }
    
    public MonitorPage(Descriptor desc) {
        if (desc == null) {
            descriptor = new Descriptor();
        } else {
            descriptor = desc.clone();
            PersistenceService service = Console.getConsole().getSingleton(PersistenceService.class);
            if (descriptor.getView() != null) {
                view = (PersistableMonitorView) service.make(descriptor.getView());
                if (view != null && descriptor.getFilter() != null) {
                    PersistableAgentChannelsFilter filter = (PersistableAgentChannelsFilter) service.make(descriptor.getFilter());
                    if (filter != null) {
                        view.setFilter(filter);
                    }
                }
            }
        }
    }
    
    public MonitorPage(PersistableMonitorView view, PersistableAgentChannelsFilter filter, String name) {
        this();
        this.view = view;
        view.setFilter(filter);
        descriptor.setName(name);
    }

// -- Setters/getters : --------------------------------------------------------   

    public JComponent getPanel() {
        if (panel == null && view != null) {
//            panel = view.getPanel();
            panel = DataPage.wrap(view.getPanel());
        }
        return panel;
    }

    public PersistableMonitorView getView() {
        return view;
    }

    public void setView(PersistableMonitorView view) {
        this.view = view;
        panel = null;
    }
    
    public String getName() {
        return descriptor.getName();
    }
    
// -- Saving/restoring : -------------------------------------------------------
    
    static public class Descriptor extends Persistable.Descriptor {

        private PersistableMonitorView.Descriptor view;
        private DataPanelDescriptor panel;
        private PersistableAgentChannelsFilter.Descriptor filter;

        public PersistableMonitorView.Descriptor getView() {
            return view;
        }

        public void setView(PersistableMonitorView.Descriptor view) {
            this.view = view;
        }

        public DataPanelDescriptor getPanel() {
            return panel;
        }

        public void setPanel(DataPanelDescriptor panel) {
            this.panel = panel;
        }

        public PersistableAgentChannelsFilter.Descriptor getFilter() {
            return filter;
        }

        public void setFilter(PersistableAgentChannelsFilter.Descriptor filter) {
            this.filter = filter;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor) super.clone();
            if (desc.view != null) desc.view = desc.view.clone();
            if (desc.filter != null) desc.filter = desc.filter.clone();
            return desc;
        }
        
    }

    @Override
    public Descriptor getDescriptor() {
        return descriptor;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = descriptor.clone();
        if (view != null) {
            desc.setView(view.save());
            AgentChannelsFilter filter = view.getFilter();
            if (filter instanceof PersistableAgentChannelsFilter) {
                PersistableAgentChannelsFilter.Descriptor d = ((PersistableAgentChannelsFilter)filter).save();
                desc.setFilter(d);
            }
        }
        if (panel == null) {
            desc.setPanel(null);
        } else {
            desc.setPanel(DataPanelDescriptor.get(panel));
        }
        return desc;
    }

    @Override
    public MonitorPage edit(String title, Component parent) {
        return MonitorPageDialog.edit(this, title, parent);
    }
    
}
