package org.lsst.ccs.gconsole.base.panel;

import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.function.Consumer;
import javax.swing.Icon;

/**
 * Enumeration of standard properties of a graphical console panel.
 *
 * @author onoprien
 */
public enum Panel implements Serializable {
    
// -- Fields : -----------------------------------------------------------------

    TYPE(PanelType.class),
    GROUP(String.class),
    TITLE(String.class),
    ICON(Icon.class),
    OPEN(Boolean.class),
    SELECTED(Boolean.class),
    ICONIZED(Boolean.class),
    DOCKED(Boolean.class),
    SIZE(Dimension.class),
    LOCATION(Point.class),
    DEVICE(Object.class),
    MAXIMIZED(Boolean.class),
    LAST_DESELECTED(Long.class),
    ON_SAVE_AS(Consumer.class),
    ON_EDIT(Consumer.class),
    ON_CLOSE(Consumer.class);

    private final Class<?> type;
    
    
// -- Constructor : ------------------------------------------------------------

    private Panel(Class<?> type) {
        this.type = type;
    }
    
    
// -- Getters : ----------------------------------------------------------------

    public Class<?> getType() {
        return type;
    }
    
    
// -- Static utility methods : -------------------------------------------------
    
    static public Panel getKey(Object key) {
        return key instanceof Panel ? (Panel) key : Panel.valueOf(key.toString());
    }
    
    
// -- Checking value validity : ------------------------------------------------

    public boolean isValueValid(Object value) {
        return value == null || type.isInstance(value);
    }

    public void checkValue(Object value) {
        if (!(isValueValid(value))) {
            throw new IllegalArgumentException("Illegal value type " + value.getClass() + " for panel state attribute " + this);
        }
    }

    static public boolean isValueValid(Object key, Object value) {
        if (value == null) {
            return true;
        } else if (key instanceof Panel) {
            return ((Panel) key).isValueValid(value);
        } else {
            try {
                return Panel.valueOf(key.toString()).isValueValid(value);
                
            } catch (IllegalArgumentException x) {
                return true;
            }
        }
    }

    static public void checkValue(Object key, Object value) {
        if (!(isValueValid(key, value))) {
            throw new IllegalArgumentException("Illegal value type " + value.getClass() + " for panel state attribute " + key);
        }
    }
}
