package org.lsst.ccs.gconsole.base.filter;

import java.util.*;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Filter that displays basic data for all subsystems.
 *
 * @author onoprien
 */
public class Subsystems extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    

// -- Life cycle : -------------------------------------------------------------
    
//    @Create(category = "AgentChannelsFilter",
//            name = "Subsystems",
//            path = "Built-In/Subsystems",
//            description = "Channels filter used to display basic information on all subsystems present on the buses.")
    public Subsystems() {}
    
// -- Implementing filter : ----------------------------------------------------

    @Override
    public String getDisplayPath(AgentChannel channel) {
        return channel.getAgentName();
    }

    @Override
    public String getOriginPath(String displayPath) {
        return null;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("/runtimeInfo/uptime"); // just an arbitrary infrequently updated channel
    }

    @Override
    public List<String> getFields(boolean compact) {
        return compact ? 
                Collections.singletonList(AgentChannel.Key.VALUE) : 
                Arrays.asList(new String[] {AgentChannel.Key.VALUE, "agentType"});
    }

}

