package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.*;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeSelectionModel;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.annotations.Command.CommandCategory;
import org.lsst.ccs.gconsole.services.lock.Locker;
import org.lsst.ccs.gconsole.services.lock.LockService;
import org.lsst.ccs.gconsole.util.tree.SModel;
import org.lsst.ccs.gconsole.util.tree.SNode;
import org.lsst.ccs.gconsole.util.tree.STree;

/**
 * Graphics panel that displays a tree of subsystem components.
 * Updated by calls to {@code updateData(AgentHandle dict)}.
 * Is listened to by {@code CommandListPanel} that implements {@code TreeSelectionListener}.
 *
 * @author onoprien
 */
public final class ComponentTree extends STree<Dictionary> {

// -- Fields : -----------------------------------------------------------------
    
    private final AgentPanel.Descriptor descriptor;
    private Locker agent;

// -- Life cycle : -------------------------------------------------------------
    
    ComponentTree(AgentPanel agentPanel) {
        super();
        descriptor = agentPanel.descriptor;
        getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        setCellRenderer(new Renderer());
    }
    
    
// -- Updates : ----------------------------------------------------------------
    
    void updateData(Locker agentHandle){
        Descriptor d = agent == agentHandle ? save() : null;
        agent = agentHandle;
        if (agent == null) {
            setModel(new SModel<>());
        } else {
            Map data = new TreeMap<>();
            for (Map.Entry<String, Dictionary> e : agent.getDictionaries().entrySet()) {
                Dictionary dict = e.getValue();
                if (dict.size() > 0) {
                    for (DictionaryCommand com : dict) {
                        if (!((descriptor.isHideSystem() && com.getCategory().equals(CommandCategory.SYSTEM)) || (descriptor.isHideLocked() && Browser.isCommandLocked(com, agent)))) {
                            data.put(e.getKey(), dict);
                            break;
                        }
                    }
                }
            }
            SModel<Dictionary> model = new SModel<>();
            model.sort(null);
            model.update(data);
            setModel(model);
            if (d != null) {
                restore(d);
            }
            expandLevel(2);
        }
    }

    
// -- Getters : ----------------------------------------------------------------
    
    public Locker getAgent() {
        return agent;
    }
    
    
// -- Getters : ----------------------------------------------------------------
    
    
// -- Local classes : ----------------------------------------------------------
    
    private class Renderer extends DefaultTreeCellRenderer {
        
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (greyOut((SNode<Dictionary>)value)) {
                setForeground(Color.GRAY);
                setFont(getFont().deriveFont(Font.ITALIC));
            } else {
                setForeground(Color.BLACK);
                setFont(getFont().deriveFont(Font.PLAIN));
            }
            
            
            
            setForeground(greyOut((SNode<Dictionary>)value) ? Color.GRAY : Color.BLACK);
            return this;
        }
        
        boolean greyOut(SNode<Dictionary> node) {
            Enumeration<SNode<Dictionary>> children = node.children();
            while (children.hasMoreElements()) {
                if (!greyOut(children.nextElement())) {
                    return false;
                }
            }
            Dictionary d = node.getUserObject();
            if (d != null) {
                for (DictionaryCommand dc : d) {
                    if (!Browser.isCommandLocked(dc, agent)) {
                        return false;
                    }
                }
            }
            return true;
        }
        
    }

}
