package org.lsst.ccs.gconsole.base.filter;

import java.util.*;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Filter that selects subsystem state channels.
 *
 * @author onoprien
 */
public class CoreStates extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    private final String name;
    private final List<String> agents;
    
    private final int cut = 5;
    static public List<String> CHANNELS = Collections.unmodifiableList(Arrays.asList(
            "/state/PhaseState",
            "/state/OperationalState",
            "/state/ConfigurationState",
            "/state/AlertState",
            "/state/CommandState"));

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = "AgentChannelsFilter",
            name = "Core States",
            path = "Built-In/Core States",
            description = "Selects core state channels, renames them to shorten the path.")
    public CoreStates(
            @Par(def = "Core states", desc = "Filter name.") String name,
            @Par(def = Par.NULL, desc = "List of subsystems accepted by this filter. If null, all subsystems are accepted.") List<String> agents)
    {
        this.name = name;
        this.agents = agents == null ? null : Collections.unmodifiableList(new ArrayList<>(agents));
    }
    
// -- Implementing filter : ----------------------------------------------------
    
    @Override
    public List<String> getDisplayPaths(AgentChannel channel) {
        String path = channel.getLocalPath();
        String displayPath = channel.getAgentName() + path.substring(cut, path.length() - cut);
        return Collections.singletonList(displayPath);
    }
    
    @Override
    public List<String> getOriginPaths(String displayPath) {
        int i = displayPath.indexOf('/');
        String agentName = displayPath.substring(0, i);
        return Collections.singletonList(agentName +"/state"+ displayPath.substring(i) +"State");
    }

    @Override
    public List<String> getOriginChannels() {
        return CHANNELS;
    }

    @Override
    public List<String> getAgents() {
        return agents;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public List<String> getFields(boolean compact) {
       return Collections.singletonList("VALUE");
    }

}

