package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;

/**
 * Default {@link MonitorView}.
 * Displays pages in tabs and configuration view at the bottom.
 *
 * @author onoprien
 */
public final class DefaultView extends CompoundView {

// -- Fields : -----------------------------------------------------------------
    
    private final TabbedView tabbedView;
    private final ConfigView controlView;

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = MonitorView.CATEGORY,
            name = "Default View",
            path = "Built-In/Default",
            description = "Default monitoring data view.")
    public DefaultView() {
        super(new JPanel(new BorderLayout()));
        descriptor = new Descriptor();
        tabbedView = new TabbedView();
        addView(tabbedView, Mode.INDEPENDENT);
        getPanel().add(tabbedView.getPanel(), BorderLayout.CENTER);
        controlView = new ConfigView();
        addView(controlView, Mode.INDEPENDENT);
        getPanel().add(controlView.getPanel(), BorderLayout.SOUTH);
    }
    
    @Create(category = MonitorView.CATEGORY,
            name = "Optimized Default View",
            path = "Built-In/Default Optimized",
            description = "Default monitoring data view optimized for use with a large number of channels.")
    static public DefaultView makeOptimized() {
        DefaultView view = new DefaultView();
        view.tabbedView.setViewFactory(name -> new LazyTreeView());
        return view;
    }

    @Override
    public void setFormatter(MonitorFormat formatter) {
        tabbedView.setFormatter(formatter);
    }

    @Override
    public MonitorFormat getFormater() {
        return tabbedView.getFormater();
    }
    
    
// -- Saving/restoring : -------------------------------------------------------
    
    static public class Descriptor extends CompoundView.Descriptor {
        
    }

}
