package org.lsst.ccs.gconsole.plugins.tracer;

import java.io.Serializable;
import java.util.function.Predicate;

import org.lsst.ccs.bus.messages.BusMessage;

/**
 * Adapter for using {@code Predicate[BusMessage]} as {@link MessageFilter}.
 *
 * @author onoprien
 */
public class MessageFilterAdapter implements MessageFilter {

// -- Fields : -----------------------------------------------------------------
    
    private final String name;
    private final String description;
    private final Predicate<BusMessage<? extends Serializable, ?>> delegate;

// -- Life cycle : -------------------------------------------------------------
    
    public MessageFilterAdapter(Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this(null, null, filter);
    }

    public MessageFilterAdapter(String name, String description,
            Predicate<BusMessage<? extends Serializable, ?>> filter) {
        this.name = name;
        this.description = description;
        delegate = filter;
    }

// -- Implementing MessageFilter :  --------------------------------------------
    
    @Override
    public String getPath() {
        return name;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        return delegate.test(filteredMessage.getBusMessage()) ? filteredMessage : null;
    }

}
