package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import org.lsst.ccs.gconsole.services.persist.Persistable;

/**
 * {@code MonitorView} that can be saved and restored through the persistence service.
 *
 * @author onoprien
 */
public interface PersistableMonitorView extends MonitorView, Persistable {

    @Override
    public default String getName() {
        return getDescriptor().getName();
    }

    @Override
    public default PersistableMonitorView edit(String title, Component parent) {
        return (PersistableMonitorView) Persistable.super.edit(title, parent);
    }
    
}
