package org.lsst.ccs.gconsole.base.filter;

import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.services.persist.Persistable;

/**
 * {@code AgentChannelsFilter} that can be saved and restored through the persistence service.
 *
 * @author onoprien
 */
public interface PersistableAgentChannelsFilter extends AgentChannelsFilter, Persistable {

    
    /**
     * Returns the name of this filter.
     * The default implementation forwards the call to Persistable's descriptor.
     * 
     * @return 
     */
    @Override
    public default String getName() {
        return getDescriptor().getName();
    }
    
// -- Factory for "Unfiltered" filters : ---------------------------------------
    
    @Create(category = AgentChannelsFilter.CATEGORY,
            name = "Unfiltered",
            path = "Built-In/Unfiltered",
            description = "Filter that accepts all channels and leaves their paths unchanged. Use with caution - unfiltered displays contain an enormous number of data channels and may be very slow to load.")
    static public PersistableAgentChannelsFilter getUnfiltered() {
        return ALL;
    }
    
}
