/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.command;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandSender;
import org.lsst.ccs.gconsole.agent.command.CommandTargetAgent;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;

public class CommandSenderTest
extends CcsTestCaseTemplate {
    private volatile StringBuilder sb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecute() throws Exception {
        System.out.println("Test execute()...");
        try {
            CommandSenderTest commandSenderTest;
            CommandTargetAgent worker = new CommandTargetAgent();
            worker.startAgent();
            Agent console = new Agent("console", AgentInfo.AgentType.CONSOLE);
            console.startAgent();
            Assert.assertTrue((boolean)((AgentStateService)console.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)((AgentStateService)worker.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)console.getMessagingAccess().getAgentPresenceManager().waitForAgent("worker", 10L, TimeUnit.SECONDS));
            System.out.println("Agents started");
            this.sb = new StringBuilder();
            Handle handle = new Handle();
            CommandSender sender = new CommandSender(console.getMessagingAccess(), null, null, console.getScheduler());
            CommandTask task1 = sender.execute((CommandHandle)handle, Duration.ofSeconds(10L), "worker/command", new Object[]{true, 2, 2, -1, false});
            CommandTask task = sender.execute((CommandHandle)handle, Duration.ofSeconds(10L), "worker/command", new Object[]{false, 0, 2, -1, false});
            task1.getResult();
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(3L), "worker/command", new Object[]{true, 2, 3, -1, false});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(-3L), "worker/command", new Object[]{true, 1, 4, 10, false});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(3L), "worker/command", new Object[]{true, 1, 4, 10, false});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(1L), "worker/command", new Object[]{true, 3, 1, 10, false});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(10L), "worker/command", new Object[]{true, 0, 1, -1, true});
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(10L), "worker/command", new Object[]{true, 0, 4, 10, false});
            try {
                commandSenderTest = this;
                synchronized (commandSenderTest) {
                    ((Object)((Object)this)).wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            task.cancel();
            task.getResult();
            task = sender.execute((CommandHandle)handle, Duration.ofSeconds(3L), "no/such/agent/command", new Object[]{true, 1, 4, 10, false});
            task.getResult();
            try {
                commandSenderTest = this;
                synchronized (commandSenderTest) {
                    ((Object)((Object)this)).wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Assert.assertEquals((Object)"NAOATATAOTAFACS", (Object)this.sb.toString());
            this.sb = null;
            worker.shutdownAgent();
            console.shutdownAgent();
        }
        catch (InterruptedException x) {
            Assert.fail((String)"Test interrupted.");
        }
    }

    private class Handle
    implements CommandHandle {
        private Handle() {
        }

        public void onSendingFailure(Throwable exception, CommandTask source) {
            CommandSenderTest.this.sb.append("S");
        }

        public void onAck(CommandAck ack, CommandTask source) {
            CommandSenderTest.this.sb.append("A");
        }

        public void onNack(CommandNack nack, CommandTask source) {
            CommandSenderTest.this.sb.append("N");
        }

        public void onSuccess(Object result, CommandTask source) {
            CommandSenderTest.this.sb.append("O");
        }

        public void onExecutionFailure(Throwable exception, CommandTask source) {
            CommandSenderTest.this.sb.append("F");
        }

        public void onTimeout(TimeoutException exception, CommandTask source) {
            CommandSenderTest.this.sb.append("T");
        }

        public void onCancel(CancellationException exception, CommandTask source) {
            CommandSenderTest.this.sb.append("C");
        }

        public void onResult(Object result, CommandTask source) {
            CommandSenderTest.this.sb.append("R");
        }
    }
}

