package org.lsst.ccs.gconsole.util.refrig;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.plugins.monitor.CellTableView;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelSingle;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.ImageView;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;

/**
 * 
 *
 * @author onoprien
 */
public class VacuumPage {

// -- Fields : -----------------------------------------------------------------
    
    // Gauges:
    
    private final String VHX_UTT_GCC_01 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_GCC_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VHX_UTT_GHF_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_GHF_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_GCC_02 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    
    // Valves:
    
    private final String VHX_UUT_VGC_01 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_VGC_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String L3_O_RING = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String L3_HOUSING_0_RING = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String FEEDTHRU_RING_O_RING = "demo-subsystem-with-monitoring/main";
    private final String PUMP_PLATE_0_RING = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    
    // ma:
    
    private final String[] VHX_UTT_PIP_04 = {"demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1"};
    private final String[] VCR_UTT_PIP_00_thru_05 = {"demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1"};
    private final String[] VHX_UTT_PIP_03 = {"demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1"};
    private final String[] VCR_UTT_PIP_04 = {"demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1", "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1"};
    
    // rpm:
    
    private final String VHX_UTT_PTM_01 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    private final String VCR_UTT_PTM_00 = "demo-subsystem-with-monitoring/main/DemoDevice1/DemoChannel1";
    
    private ImageView view;
    
    private final MonitorField gaugeField, maField, lsField, rpmField, valveField;

// -- Life cycle : -------------------------------------------------------------
    
    public VacuumPage() {
        
        FormattedValue fv = new FormattedValue();
        fv.horizontalAlignment = SwingUtilities.CENTER;
        fv.format = "<html><center>%1$6.1e<br>Torr";
        gaugeField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "%1$5.3f ma";
        maField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "%1$5.1f l/s";
        lsField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "%1$6.0f rpm";
        rpmField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        fv.format = "open";  //FIXME
        valveField = new MonitorField(MonitorField.VALUE.getKey(), null, fv, MonitorField.VALUE.getKeys());
        
    }
    
    public ImageView getView() {
        
        if (view != null) return view;
        
        try {
            
            BufferedImage back = ImageIO.read(ImageView.class.getResource("/org/lsst/ccs/gconsole/util/refrig/vacuum.png"));
            view = new ImageView("Vacuum", back, .5, 2.);
            
            
            placeGauge(0.4231, 0.0820, VHX_UTT_GCC_01);
            placeGauge(0.3739, 0.2730, VCR_UTT_GCC_00);
            placeGauge(0.5572, 0.2570, VHX_UTT_GHF_00);
            placeGauge(0.5203, 0.4696, VCR_UTT_GHF_00);
            placeGauge(0.5510, 0.8048, VCR_UTT_GCC_02);
            
            placeValve(0.5055, 0.3338, VHX_UUT_VGC_01, JComponent.CENTER_ALIGNMENT, JComponent.BOTTOM_ALIGNMENT);
            placeValve(0.3469, 0.4936, VCR_UTT_VGC_00, JComponent.CENTER_ALIGNMENT, JComponent.BOTTOM_ALIGNMENT);
            placeValve(0.0701, 0.8628, L3_O_RING, JComponent.RIGHT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            placeValve(0.1562, 0.8586, L3_HOUSING_0_RING, JComponent.RIGHT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            placeValve(0.2312, 0.8614, FEEDTHRU_RING_O_RING, JComponent.RIGHT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            placeValve(0.3137, 0.8586, PUMP_PLATE_0_RING, JComponent.RIGHT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            
            placeMa(0.5351, 0.1655, VHX_UTT_PIP_04, JComponent.LEFT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            placeMa(0.3124, 0.3946, VCR_UTT_PIP_00_thru_05, JComponent.LEFT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            placeMa(0.5166, 0.6393, VHX_UTT_PIP_03, JComponent.LEFT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
            placeMa(0.4096, 0.7624, VCR_UTT_PIP_04, JComponent.CENTER_ALIGNMENT, JComponent.TOP_ALIGNMENT);
            
            placeRpm(0.5879, 0.3585, VHX_UTT_PTM_01);
            placeRpm(0.5855, 0.5203, VCR_UTT_PTM_00);
            
            
        } catch (IOException e) {
            e.printStackTrace();
        }
        return view;
    }
    
    private void placeGauge(double x, double y, String ch) throws IOException {

        DefaultMonitorCell c = new DefaultMonitorCell(new DisplayChannelSingle(ch, null, null), gaugeField);
        
        CellTableView table = new CellTableView(1, 1, c);
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(JComponent.CENTER_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
//        item.setSize(0.06, 0.07);
        item.setMaxSize(0.085, 0.055);
        view.add(item);
    }
    
    private void placeValve(double x, double y, String ch, float horAlign, float vertAlign) throws IOException {

        DefaultMonitorCell c = new DefaultMonitorCell(new DisplayChannelSingle(ch, null, null), valveField);
        
        CellTableView table = new CellTableView(1, 1, c);
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(horAlign, vertAlign);
//        item.setSize(0.06, 0.07);
        item.setMaxSize(0.2420, 0.0820);
        view.add(item);
    }
    
    private void placeMa(double x, double y, String[] ch, float horAlign, float vertAlign) throws IOException {

        DefaultMonitorCell c0 = new DefaultMonitorCell(new DisplayChannelSingle(ch[0], null, null), maField);
        DefaultMonitorCell c1 = new DefaultMonitorCell(new DisplayChannelSingle(ch[1], null, null), lsField);
        
        CellTableView table = new CellTableView(2, 1, c0, c1);
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(horAlign, vertAlign);
//        item.setSize(0.06, 0.07);
        item.setMaxSize(0.2420, 0.0820);
        view.add(item);
    }
    
    private void placeRpm(double x, double y, String ch) throws IOException {

        DefaultMonitorCell c = new DefaultMonitorCell(new DisplayChannelSingle(ch, null, null), rpmField);
        
        CellTableView table = new CellTableView(1, 1, c);
        ImageView.Item item = new ImageView.Item(table);
        item.setPosition(x, y);
        item.setAlignment(JComponent.LEFT_ALIGNMENT, JComponent.CENTER_ALIGNMENT);
//        item.setSize(0.06, 0.07);
        item.setMaxSize(0.1132, 0.0382);
        view.add(item);
    }
    
    public static void main(String... a) {
        System.out.println(String.format("%1$6.1e%nss", 3.9999));
    }

}
