package org.lsst.ccs.gconsole.jas3;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.freehep.jas.JAS3;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.openide.util.Lookup;

/**
 * Application launcher.
 * 
 * @version $Id: $
 * @author onoprien
 */
public class ConsoleApplication extends JAS3 {
    
    private final AtomicBoolean exiting = new AtomicBoolean(false);

// -- Life cycle : -------------------------------------------------------------
    
    public ConsoleApplication() {
        super("CCS_Console");
    }

    public static void main(final String[] args) {

//      JOptionPane.showMessageDialog(null, "CCS_Console main "); // uncomment to enable debugger attachement

        ThreadUtil.invokeLater(() -> {
            try {
                new ConsoleApplication().createFrame(args).setVisible(true);
            } catch (HeadlessException x) {
                System.out.println("Fatal Error: " + x.getMessage());
            } catch (Throwable t) {
                System.out.println("Fatal Error: " + t.getMessage());
                error(null, "Fatal Error", t);
                System.exit(1);
            }
        });

    }

    @Override
    protected void init() {
        super.init();
        Properties pp = getUserProperties();
        try {
            int x = Integer.parseInt(pp.getProperty("window-x"));
            int y = Integer.parseInt(pp.getProperty("window-y"));
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int w = gd.getDisplayMode().getWidth();
            int h = gd.getDisplayMode().getHeight();
            if (x < 0 || x > w-50) {
                pp.setProperty("window-x", "0");
            }
            if (y < 0 || y > h-50) {
                pp.setProperty("window-y", "0");
            }
        } catch (NullPointerException | NumberFormatException x) {
        }
        
    }

    @Override
    public void exit() {
        
        // if not the first call, do nothing
        
        if(exiting.getAndSet(true)) {
            return;
        }
        
        // stop and shutdown plugins
        
        try {
            ThreadUtil.invokeAndWait(() -> {
                try {
                    Collection<? extends ConsolePlugin> plugins = getLookup().lookup(new Lookup.Template(ConsolePlugin.class, null, null)).allInstances();
                    plugins.forEach(plugin -> {
                        try {
                            plugin.stop();
                        } catch (Throwable t) {
                        }
                    });
                    plugins.forEach(plugin -> {
                        try {
                            plugin.shutdown();
                        } catch (Throwable t) {
                        }
                    });
                    Console.getConsole().shutdownAgent();
                } catch (Throwable t) {
                    System.out.println(t);
                }
            });
        } catch (InterruptedException | InvocationTargetException x) {
        }
        
        // shut down Agent
        
        ((Jas3Console) Console.getConsole()).superShutdownAgent();
        
        // shutdown Jas3

        super.exit();
    }
    
    
// -- Handling properties : ----------------------------------------------------
    
    /**
     * Adds properties from application definition files.
     * 
     * @return Modified application properties.
     * @throws org.freehep.application.Application.InitializationException 
     */
    @Override
    protected Properties createAppProperties() throws InitializationException {
        Properties appProp = super.createAppProperties();
        Properties ccsProp = BootstrapResourceUtils.getBootstrapProperties("gui.properties");
        String appName = ccsProp.getProperty("org.lsst.ccs.application.name");
        String prefName = ccsProp.getProperty("org.lsst.ccs.gui.preferences", appName);
        if (prefName != null) {
            if (!prefName.endsWith(".properties")) prefName = prefName + ".properties";
            appProp.setProperty("userPrefDir", appProp.getProperty("org.lsst.ccs.gui.home") +"/"+ prefName);
        }
        ccsProp.stringPropertyNames().forEach(key -> appProp.setProperty(key, ccsProp.getProperty(key)));
        return appProp;
    }

}
