package org.lsst.ccs.gconsole.services.aggregator;

import java.util.*;
import org.lsst.ccs.bus.messages.StatusMessage;

/**
 * Mutable extension of {@link AgentStatusEvent}.
 * Provides methods to accumulate changes.
 *
 * @author onoprien
 */
public class MutableAgentStatusEvent extends AgentStatusEvent {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------
    
    MutableAgentStatusEvent(AgentStatusAggregator aggregator, StatusMessage message) {
        super(aggregator, message, new LinkedHashMap<>(), new ArrayList<>(0), new ArrayList<>(0));
    }
    
// -- Modification : -----------------------------------------------------------
    
    public void addChange(AgentChannel channel, String attributeKey) {
        if (attributeKey == null) attributeKey = AgentChannel.Key.VALUE.toString();
        List<String> changedAttributes = statusChanges.get(channel);
        if (changedAttributes == null) {
            changedAttributes = new ArrayList<>(1);
            statusChanges.put(channel, changedAttributes);
        }
        changedAttributes.add(attributeKey);
    }
    
    public void addAddedChannel(AgentChannel channel) {
        addedChannels.add(channel);
    }
    
    public void addRemovedChannel(AgentChannel channel) {
        removedChannels.add(channel);
    }

    public void validate() {
        if (!statusChanges.isEmpty()) {
            addedChannels.forEach(channel -> statusChanges.remove(channel));
            removedChannels.forEach(channel -> statusChanges.remove(channel));
        }
    }
    
}
