package org.lsst.ccs.gconsole.plugins.tracer.filters;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.gconsole.base.InstanceDialog;
import org.lsst.ccs.gconsole.plugins.tracer.FilteredMessage;
import org.lsst.ccs.gconsole.plugins.tracer.MessageFilter;

/**
 * Adapter to simplify implementing parameterized {@link MessageFilter}.
 *
 * @author onoprien
 */
abstract public class AbstractMessageFilter implements MessageFilter {

// -- Fields : -----------------------------------------------------------------
    
    private String[] par;
    private InstanceDialog.Descriptor descriptor;

// -- Life cycle : -------------------------------------------------------------
    
    
// -- Getters/setters : --------------------------------------------------------

    @Override
    public String[] getParameters() {
        return par == null ? new String[0] : Arrays.copyOf(par, par.length);
    }

    @Override
    public void setParameters(String[] parameters) {
        par = parameters == null || parameters.length == 0 ? null : Arrays.copyOf(parameters, parameters.length);
    }

    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Serializable save() {
        return descriptor;
    }

    @Override
    public void setCreator(InstanceDialog.Descriptor dialogDescriptor) {
        descriptor = dialogDescriptor;
    }

}
