package org.lsst.ccs.gconsole.services.aggregator;

import org.lsst.ccs.bus.states.DataProviderState;

/**
 * State of a data channel.
 *
 * @author onoprien
 */
public class AgentChannelState {

// -- Fields : -----------------------------------------------------------------
    
    private int state;

// -- Life cycle : -------------------------------------------------------------
    
    public AgentChannelState(int state) {
        this.state = state;
    }
    
    public AgentChannelState(boolean isGood, boolean isOnline, boolean isLowLimitChange, boolean isHighLimitChange) {
        state = isGood ? 1 : 0;
        state <<= 1;
        state |= isOnline ? 1 : 0;
        state <<= 1;
        state |= isLowLimitChange ? 1 : 0;
        state <<= 1;
        state |= isHighLimitChange ? 1 : 0;
    }
    
    
// -- Getters : ----------------------------------------------------------------
    
    public boolean isGood() {
        return (state & 8) > 0;
    }
    
    public boolean isOnline() {
        return (state & 4) > 0;
    }
    
    public boolean isLowLimitChange() {
        return (state & 2) > 0;
    }
    
    public boolean isHighLimitChange() {
        return (state & 1) > 0;
    }
    
    
// -- Static utility methods : -------------------------------------------------
    
    static AgentChannelState merge(AgentChannelState state, DataProviderState channelState) {
        return new AgentChannelState(channelState == DataProviderState.NOMINAL, channelState != DataProviderState.OFF_LINE, state != null && state.isLowLimitChange(), state != null && state.isHighLimitChange());
    }
    
    static AgentChannelState merge(AgentChannelState state, boolean isLowLimitChange, boolean isHighLimitChange) {
        return new AgentChannelState(state == null || state.isGood(), state == null || state.isOnline(), isLowLimitChange, isHighLimitChange);
    }
    
    static boolean isGood(int flag) {
        return (flag & 8) > 0;
    }
    
    static boolean isOnline(int flag) {
        return (flag & 4) > 0;
    }
    
    static boolean isLowLimitChange(int flag) {
        return (flag & 2) > 0;
    }
    
    static boolean isHighLimitChange(int flag) {
        return (flag & 1) > 0;
    }

}
