package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.*;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.services.persist.Persistable;

/**
 * {@link MonitorView} that displays data channels in a table.
 * The table is divided into collapsible sections corresponding to pages defined by the filter associated with this view.
 *
 * @author onoprien
 */
public class SectionedTableView extends AbstractMonitorView2 {

// -- Fields : -----------------------------------------------------------------
    
    private Descriptor descriptor;
    private final JScrollPane scrollPane = new JScrollPane();
    private SectionedTable table;

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = MonitorView.CATEGORY,
            name = "Sectioned Table View",
            path = "Built-In/Sectioned Table",
            description = "Monitoring view that displays data channels in a table. The table is divided into collapsible sections corresponding to pages defined by the filter associated with this view.")
    public SectionedTableView() {
        descriptor = new Descriptor();
        scrollPane.add(new MonitorDisplay.EMPTY());
    }

// -- Getters and setters : ----------------------------------------------------
    
    @Override
    public JComponent getPanel() {
        return scrollPane;
    }

// -- Updates from status aggregator : -----------------------------------------
    
    @Override
    protected void resetChannels() {
        List<String> attributes = getFilter() == null ? null : getFilter().getFields(false);
        List<MonitorField> fields = attributes == null ? MonitorTable.DEFAULT_FIELDS : new ArrayList<>(MonitorField.getDefaultFields(attributes));
        if (table != null) {
            updateDescriptor();
            table.destroy();
        }
        table = SectionedTable.getInstance(path2data.entrySet(), fields, getDescriptor().getTable());
        if (formatter != null) {
            table.setFormat(formatter);
        }
        scrollPane.setViewportView(table.getTable());
        scrollPane.revalidate();
    }
    
    
// -- Saving/restoring : -------------------------------------------------------
    
    static public class Descriptor extends PersistableMonitorView.Descriptor {

        private SectionedTable.Descriptor table;

        public SectionedTable.Descriptor getTable() {
            return table;
        }

        public void setTable(SectionedTable.Descriptor table) {
            this.table = table;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor) super.clone();
            if (table != null) {
                table = table.clone();
            }
            return desc;
        }
        
    }

    @Override
    public Descriptor save() {
        updateDescriptor();
        return (Descriptor) descriptor.clone();
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor) descriptor.clone();
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return descriptor;
    }
    
    private void updateDescriptor() {
        if (table != null) descriptor.setTable(table.save());
    }
    
}
