package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.List;

/**
 * Data model for a graphical component that displays a single monitored value.
 * There is a single {@link MonitorField} instance associated with this model, 
 * describing the type of the displayed value, and a list of contributing {@code DisplayChannel} objects.
 * The model also contains the current {@link FormattedValue}.
 * 
 * @author onoprien
 */
public interface MonitorCell {

    /**
     * Returns the list of display channels that affect this cell.
     * @return List of contributing display channels.
     */
    List<DisplayChannel> getChannels();

    /**
     * Returns the descriptor of the monitored field this cell displays.
     * @return Monitor field descriptor.
     */
    MonitorField getField();

    /**
     * Returns the current formatted value to be displayed by this cell.
     * @return Current formatted value.
     */
    FormattedValue getFormattedValue();

    /**
     * Sets the current formatted value to be displayed by this cell.
     * @param formattedValue New formatted value.
     */
    default void setFormattedValue(FormattedValue formattedValue) {
        throw new UnsupportedOperationException();
    }
    
}
