package org.lsst.ccs.gconsole.plugins.monitor;

import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

/**
 * Default implementation of {@link DisplayChannel}.
 *
 * @author onoprien
 */
public class DisplayChannelSingle implements DisplayChannel {

// -- Fields : -----------------------------------------------------------------

    private final String path;
    private AgentChannel channel;
    private Updatable view;


// -- Life cycle : -------------------------------------------------------------

    public DisplayChannelSingle(String path, AgentChannel channel, Updatable view) {
        this.path = path;
        this.channel = channel;
        this.view = view;
    }

    
// -- Getters and setters : ----------------------------------------------------

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public Updatable getTarget() {
        return view;
    }

    @Override
    public void setTarget(Updatable view) {
        this.view = view;
    }

    @Override
    public AgentChannel getChannel() {
        return channel;
    }

    @Override
    public void setChannel(AgentChannel channel) {
        this.channel = channel;
    }

}
