package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author emarin
 */
public final class HTMLTextPane extends JTextPane implements HasPopupItems {

    private static final int MAX_LENGTH = 10000;
    private final HTMLEditorKit kit;
    private final HTMLDocument doc;
    private final Action clearAction;
    private final Logger log = Logger.getLogger("org.lsst.ccs.plugin.jas3.dictionary");
    
    public HTMLTextPane() {
        
        setEditable(false);
        try {
            ((DefaultCaret)getCaret()).setUpdatePolicy(DefaultCaret.ALWAYS_UPDATE);
        } catch (ClassCastException x) {
        }
        
        kit = new HTMLEditorKit();
        doc = new HTMLDocument();
        this.setEditorKit(kit);
        
        // Font management
        
        Font font = new Font(Font.MONOSPACED, Font.PLAIN, 15);
        String bodyrule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt;}";
        doc.getStyleSheet().addRule(bodyrule);

        this.setDocument(doc);
        
        // Clear action
        
        clearAction = new AbstractAction("Clear") {
            @Override
            public void actionPerformed(ActionEvent e) {
                HTMLTextPane.this.setText("");
            }
            
        };        
        
    }
    
    public void insertHTML(String s){
        try {
            kit.insertHTML(doc, doc.getLength(), s, 0, 0, null);
            int overLength=doc.getLength() - MAX_LENGTH;
            if (overLength > 0){
                removeOverLength(overLength);
            }
        } catch (BadLocationException ex) {
            log.error(ex);
        } catch (IOException ex) {
            log.error(ex);
        }
    }
    
    private void removeOverLength(int overLength) throws BadLocationException{
                doc.remove(0,overLength);
    }

    @Override
    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component cmpnt, Point point) {
        menu.add(new JMenuItem(clearAction));
        return menu;
    }
    
}
