package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Savable;

/**
 * Interface to be implemented by all types of command browsers.
 * A {@code Browser} handles the root page of the command browser tool.
 *
 * @author onoprien
 */
public interface Browser extends Savable {
        
    ImageIcon ICON_UNLOCKED = new ImageIcon(Browser.class.getResource("ic_lock_open_black_18dp.png"), "unlocked");
    ImageIcon ICON_LOCKED = new ImageIcon(Browser.class.getResource("ic_lock_black_18dp.png"), "locked");
    ImageIcon ICON_UNAVAILABLE = null;
    
    /**
     * Returns the name of this command browser.
     * @return Browser name.
     */
    String getName();
    
    /**
     * Initializes the browser if necessary, and returns its root graphics component.
     * @return Root graphics component for this browser.
     */
    JComponent getPanel();
    
    /**
     * Releases resources and shuts down this browser.
     */
    void shutdown();
    
    
// -- Utilities : --------------------------------------------------------------
    
    /**
     * Returns {@code true} if the specified command is currently unavailable for use based on lock and level settings.
     * If the specified dictionary is {@code null}, always returns {@code true} (for compatibility with legacy code).
     * 
     * @param command Command to check.
     * @param dictionary Dictionary the command belongs to.
     * @return {@code true} If the command is locked.
     */
    static public boolean isCommandLocked(DictionaryCommand command, Dictionary dictionary) {
        if (dictionary == null) {
            return true;
        } else {
            return command.getLevel() > dictionary.getLevelForType(command.getType());
        }
    }

// -- Savin/restoring : --------------------------------------------------------

    @Override
    public Descriptor save();
    
    public class Descriptor implements Serializable {

        private String name;
        private String agent;
        private AgentPanel.Descriptor agentPanel;
        private DataPanelDescriptor page;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAgent() {
            return agent;
        }

        public void setAgent(String agent) {
            this.agent = agent;
        }

        public AgentPanel.Descriptor getAgentPanel() {
            return agentPanel;
        }

        public void setAgentPanel(AgentPanel.Descriptor agentPanel) {
            this.agentPanel = agentPanel;
        }

        public DataPanelDescriptor getPage() {
            return page;
        }

        public void setPage(DataPanelDescriptor page) {
            this.page = page;
        }

    }
    
}
