package org.lsst.ccs.gconsole.base.filter;

import java.util.concurrent.CopyOnWriteArrayList;

/**
 * Adapter to simplify implementing {@link AgentChannelsFilter}.
 * Provides machinery for handling listeners and minimal implementation of {@code Persistable}.
 *
 * @author onoprien
 */
abstract public class AbstractChannelsFilter implements PersistableAgentChannelsFilter  {

// -- Fields : -----------------------------------------------------------------
    
    private final CopyOnWriteArrayList<AgentChannelsFilter.Listener> listeners = new CopyOnWriteArrayList<>();
    protected Descriptor descriptor;

// -- Handling listeners : -----------------------------------------------------
    
    @Override
    public void addListener(AgentChannelsFilter.Listener listener) {
        listeners.addIfAbsent(listener);
    }
    
    @Override
    public void removeListener(AgentChannelsFilter.Listener listener) {
        listeners.remove(listener);
    }
    
    protected void notifyListeners() {
        AgentChannelsFilter.Event event = new AgentChannelsFilter.Event(AbstractChannelsFilter.this);
        listeners.forEach(listener -> listener.filterChanged(event));
    }
    
    
// -- Saving/restoring : -------------------------------------------------------

    @Override
    public Descriptor getDescriptor() {
        if (descriptor == null) descriptor = new Descriptor();
        return descriptor;
    }

}
