/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;

public class Configuration
extends AbstractChannelsFilter {
    private final String name;
    private final List<String> agents;

    @Create(category="AgentChannelsFilter", name="Configuration", path="Built-In/Configuration", description="Channels filter that selects subsystem configuration channels.")
    public Configuration(@Par(def="Configuration", desc="Filter name.") String name, @Par(def="_null_", desc="List of subsystems accepted by this filter. If null, all subsystems are accepted.") List<String> agents) {
        this.name = name;
        this.agents = agents == null ? null : new ArrayList<String>(agents);
    }

    @Override
    public List<String> getDisplayPaths(String originPath) {
        String displayPath = originPath.replaceFirst("/configuration/", "/");
        return Collections.singletonList(displayPath);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath.replaceFirst("/", "/configuration/");
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("/configuration/");
    }

    @Override
    public List<String> getAgents() {
        return this.agents == null ? null : Collections.unmodifiableList(this.agents);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

