package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import org.lsst.ccs.gconsole.services.persist.Persistable;

/**
 * {@code MonitorView} that can be saved and restored through the persistence service.
 *
 * @author onoprien
 */
public interface PersistableMonitorView extends MonitorView, Persistable {

    @Override
    public default String getName() {
        return getDescriptor().getName();
    }
    
//    /**
//     * Descriptor of a {@code PersistableMonitorView}.
//     * All {@code PersistableMonitorView} subclasses should use descriptors that extend this class.
//     */
//    static public class Descriptor extends Persistable.Descriptor {
//
//        @Override
//        public Descriptor clone() {
//            return (Descriptor) super.clone();
//        }
//        
//    }

    @Override
    public default PersistableMonitorView edit(String title, Component parent) {
        return (PersistableMonitorView) Persistable.super.edit(title, parent);
    }
    
}
