/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.Datas;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.server.TrendingResult;
import org.lsst.ccs.messaging.AgentPresenceListener;

@Plugin(name="LSST Rest Service Plugin", id="rest-service", description="Plugin that handles connection to the REST server.")
public class LsstRestService
extends ConsolePlugin {
    public static final String FROM_BUS_PROPERTY = "fromBus";
    public static final String HOST_PROPERTY = "server";
    public static final String PORT_PROPERTY = "port";
    public static final String CONNECT_ON_STARTUP_PROPERTY = "connectOnStartup";
    private Client client;
    private WebResource server;
    private boolean refreshInProgress;
    private boolean refreshRequested;
    private AgentPresenceListener agentsListener;
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();

    @Override
    public void initialize() {
        this.getServices().addProperty(FROM_BUS_PROPERTY, true);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, null, "${fromBus} Use REST server found on CCS buses.");
        this.getServices().addProperty(HOST_PROPERTY, "localhost");
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, "URL", "Server: ${server#history=5}");
        this.getServices().addProperty(PORT_PROPERTY, 8080);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, "URL", "Port: ${port}");
        this.getServices().addProperty(CONNECT_ON_STARTUP_PROPERTY, true);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, null, "${connectOnStartup} Connect on startup.");
        this.getConsole().getLogger().setLevel(Level.FINE);
    }

    @Override
    public void start() {
        if (((Boolean)this.getServices().getProperty(CONNECT_ON_STARTUP_PROPERTY)).booleanValue()) {
            this.refreshConnection();
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.client != null) {
            this.client.destroy();
        }
    }

    @Override
    public void propertiesChanged(Object source, Map<String, Object> changes) {
        Set<String> keys = changes.keySet();
        if (keys.contains(HOST_PROPERTY) || keys.contains(PORT_PROPERTY) || keys.contains(FROM_BUS_PROPERTY)) {
            this.triggerRefreshConnection();
        }
    }

    public synchronized void refreshConnection() {
        if (!this.refreshInProgress) {
            this.triggerRefreshConnection();
        }
    }

    private synchronized void triggerRefreshConnection() {
        if (!this.refreshInProgress) {
            this.refreshRequested = false;
            this.refreshInProgress = true;
            Thread t = new Thread(this::connect, "REST Connector");
            t.setDaemon(true);
            t.start();
        } else {
            this.refreshRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        String url = null;
        try {
            url = this.getURL();
            if (url == null) {
                this.server = null;
            } else {
                this.getConsole().getLogger().fine((Object)("Connecting to REST server " + url));
                this.server = this.client.resource(url).path("dataserver");
                this.server.head();
                this.getConsole().getLogger().fine((Object)"REST server connection successful.");
            }
        }
        catch (RuntimeException e) {
            this.server = null;
            this.getConsole().getLogger().warn((Object)("Unable to connect to REST server at " + url), (Throwable)e);
        }
        finally {
            boolean repeat = false;
            LsstRestService lsstRestService = this;
            synchronized (lsstRestService) {
                if (this.refreshRequested) {
                    repeat = true;
                    this.refreshRequested = false;
                } else {
                    this.notifyAll();
                    this.refreshInProgress = false;
                    this.fireEvent();
                }
            }
            if (repeat) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getURL() {
        AgentPresenceListener oldListener;
        LsstRestService lsstRestService = this;
        synchronized (lsstRestService) {
            oldListener = this.agentsListener;
            if (this.client == null) {
                this.client = Client.create((ClientConfig)new DefaultClientConfig());
            }
        }
        if (oldListener != null) {
            this.getConsole().getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener(oldListener);
        }
        String url = null;
        if (((Boolean)this.getServices().getProperty(FROM_BUS_PROPERTY)).booleanValue()) {
            String agentName = null;
            for (AgentInfo agent : this.getConsole().getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
                if (!AgentCategory.REST_SERVER.name().equals(agent.getAgentProperty("agentCategory"))) continue;
                String host = agent.getAgentProperty("rest-service-addr");
                String port = agent.getAgentProperty("rest-service-port");
                String entryPoint = agent.getAgentProperty("rest-service-entrypoint");
                url = String.format("http://%s:%d%s", host, Integer.valueOf(port), entryPoint);
                agentName = agent.getName();
                break;
            }
            LsstRestService lsstRestService2 = this;
            synchronized (lsstRestService2) {
                this.agentsListener = agentName == null ? new AgentConnectListener() : new AgentDisconnectListener(agentName);
            }
            this.getConsole().getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(this.agentsListener);
        } else {
            String host = null;
            try {
                host = this.getServices().getProperty(HOST_PROPERTY).toString();
                int port = (Integer)this.getServices().getProperty(PORT_PROPERTY);
                url = String.format("http://%s:%d/rest/data", host, port);
            }
            catch (RuntimeException x) {
                this.getConsole().getLogger().warn((Object)("Invalid server " + host + " or port " + this.getServices().getProperty(PORT_PROPERTY)));
                throw x;
            }
        }
        return url;
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    private void fireEvent() {
        SwingUtilities.invokeLater(() -> {
            ChangeEvent event = new ChangeEvent(this);
            this.listeners.forEach(listener -> listener.stateChanged(event));
        });
    }

    public DataChannel.DataChannelList getChannelList() {
        WebResource resource = this.getServer();
        if (resource == null) {
            return null;
        }
        resource = resource.path("listchannels");
        return (DataChannel.DataChannelList)resource.accept(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
    }

    public DataChannel.DataChannelList getChannelList(long begin) {
        WebResource resource = this.getServer();
        if (resource == null) {
            return null;
        }
        resource = resource.path("listchannels");
        resource = resource.queryParam("maxIdleSeconds", String.valueOf(begin));
        return (DataChannel.DataChannelList)resource.accept(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
    }

    public TrendingData getLatestData(String path) {
        WebResource resource = this.getServer();
        if (resource == null) {
            return null;
        }
        resource = resource.path("data/latest").queryParam("path", path);
        return (TrendingData)resource.accept(new String[]{"text/xml"}).get(TrendingData.class);
    }

    public Datas getData(long begin, long end, String flavor, int nBins, String ... paths) {
        WebResource resource = this.getServer();
        if (resource == null) {
            return null;
        }
        resource = resource.path("data/search");
        resource = resource.queryParam("t1", String.valueOf(begin)).queryParam("t2", String.valueOf(end));
        if (flavor != null) {
            resource.queryParam("flavor", flavor);
        }
        if (nBins > 0) {
            resource = resource.queryParam("n", Integer.toString(nBins));
        }
        for (String path : paths) {
            resource = resource.queryParam("path", path);
        }
        WebResource.Builder a = resource.accept(new String[]{"text/xml"});
        return (Datas)a.get(Datas.class);
    }

    public TrendingResult getData(long begin, long end, String flavor, int nBins, Integer ... ids) {
        WebResource resource = this.getServer();
        if (resource == null) {
            return null;
        }
        resource = resource.path("data");
        resource = resource.queryParam("t1", String.valueOf(begin)).queryParam("t2", String.valueOf(end));
        if (flavor != null) {
            resource.queryParam("flavor", flavor);
        }
        if (nBins > 0) {
            resource = resource.queryParam("n", Integer.toString(nBins));
        }
        for (Integer id : ids) {
            resource = resource.queryParam("id", id.toString());
        }
        return ((Data)resource.accept(new String[]{"text/xml"}).get(Data.class)).getTrendingResult();
    }

    private synchronized WebResource getServer() {
        while (this.refreshInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException x) {
                return null;
            }
        }
        return this.server;
    }

    private class AgentDisconnectListener
    implements AgentPresenceListener {
        private final String agent;

        AgentDisconnectListener(String agent) {
            this.agent = agent;
        }

        public void disconnecting(AgentInfo agent) {
            if (agent.getName().equals(this.agent)) {
                LsstRestService.this.triggerRefreshConnection();
            }
        }
    }

    private class AgentConnectListener
    implements AgentPresenceListener {
        private AgentConnectListener() {
        }

        public void connected(AgentInfo ... agents) {
            for (AgentInfo agent : agents) {
                if (!AgentCategory.REST_SERVER.name().equals(agent.getAgentProperty("agentCategory"))) continue;
                LsstRestService.this.triggerRefreshConnection();
            }
        }
    }
}

