package org.lsst.ccs.gconsole.services.persist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;

/**
 * 
 *
 * @author onoprien
 */
public class SaveDescriptorDialog extends JDialog {

// -- Fields : -----------------------------------------------------------------
    
    private Persistable.Descriptor descriptor;
    
    private final JTextField pathField;
    private final JTextField nameField;
    private final JEditorPane descriptionPane;
    private final JButton okButton;
    
    private final Pattern pathPattern = Pattern.compile("\\A[a-zA-Z][a-zA-Z_0-9 \\-/]*\\z");

// -- Life cycle : -------------------------------------------------------------
    
    private SaveDescriptorDialog(Persistable.Descriptor desc, String title, Component parent) {
        super(parent == null ? Console.getConsole().getWindow() : SwingUtilities.getWindowAncestor(parent), 
                title == null ? "Saving..." : title, 
                Dialog.ModalityType.APPLICATION_MODAL);
        descriptor = desc;
        setLayout(new BorderLayout());
        
        Box top = Box.createVerticalBox();
        add(top, BorderLayout.NORTH);
        Box box = Box.createHorizontalBox();
        top.add(box);
        box.add(new JLabel("Path: "));
        box.add(Box.createRigidArea(Const.HDIM));
        pathField = new JTextField(50);
        box.add(pathField);
        if (descriptor.getPath() != null) {
            pathField.setText(descriptor.getPath());
        }
        pathField.addCaretListener(e -> {
            validatePath();
        });
        box.add(Box.createHorizontalGlue());
        box = Box.createHorizontalBox();
        top.add(box);
        box.add(new JLabel("Name: "));
        box.add(Box.createRigidArea(Const.HDIM));
        nameField = new JTextField(50);
        box.add(nameField);
        if (descriptor.getName() != null) {
            nameField.setText(descriptor.getName());
        }
        box.add(Box.createHorizontalGlue());
        
        JPanel center = new JPanel();
        add(center, BorderLayout.CENTER);
        center.setBorder(BorderFactory.createTitledBorder("Description"));
        descriptionPane = new JEditorPane("text/plain", descriptor.getDescription());
        center.add(new JScrollPane(descriptionPane));
        descriptionPane.setEditable(true);
        descriptionPane.setPreferredSize(new Dimension(300, 200));
        
        Box buttonBox = Box.createHorizontalBox();
        add(buttonBox, BorderLayout.SOUTH);
        buttonBox.setBorder(BorderFactory.createEmptyBorder(Const.VSPACE, Const.HSPACE, Const.VSPACE, Const.HSPACE));
        buttonBox.add(Box.createHorizontalGlue());
        JButton b = new JButton("Cancel");
        b.addActionListener(e -> {
            descriptor = null;
            dispose();
        });
        buttonBox.add(b);
        buttonBox.add(Box.createRigidArea(Const.HDIM));
        okButton = new JButton("OK");
        okButton.addActionListener(e -> {
            String s = pathField.getText().trim();
            if (!s.isEmpty()) {
                descriptor.setPath(s);
                s = nameField.getText().trim();
                descriptor.setName(s.isEmpty() ? null : s);
                s = descriptionPane.getText();
                descriptor.setDescription(s.isEmpty() ? null : s);
                dispose();
            }
        });
        validatePath();
        buttonBox.add(okButton);
        buttonBox.add(Box.createRigidArea(Const.HDIM));
    }
    
    static public Persistable.Descriptor show(Persistable.Descriptor desc, String title, Component parent) {
        SaveDescriptorDialog dialog = new SaveDescriptorDialog(desc, title, parent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return dialog.descriptor;
    }
    
    
// -- Loval methods : ----------------------------------------------------------
    
    private void validatePath() {
        String s = pathField.getText();
        okButton.setEnabled(pathPattern.matcher(s).matches());
    }

}
