package org.lsst.ccs.gconsole.services.persist;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashMap;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;

/**
 * Descriptor of a graphical console data panel.
 * Contains information required to position the panel on the screen (open or closed,
 * docked or undocked, location, etc.) as well as any additional data that should be
 * associated with the panel through {@link PanelManager}.
 *
 * @author onoprien
 */
public class DataPanelDescriptor implements Serializable {

    private boolean open;
    private HashMap<String, Serializable> data;

    public boolean isOpen() {
        return open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public HashMap<String, Serializable> getData() {
        return data;
    }

    public void setData(HashMap<String, Serializable> data) {
        this.data = data;
    }
    
    static public DataPanelDescriptor get(JComponent component) {
        DataPanelDescriptor desc = new DataPanelDescriptor();
        try {
            PanelManager panMan = Console.getConsole().getPanelManager();
            boolean docked = (Boolean) panMan.get(component, Panel.DOCKED);
            desc.setOpen(true);
            if (!docked) {
                HashMap<String,Serializable> m =panMan.get(component, EnumSet.of(Panel.DEVICE, Panel.DOCKED, Panel.ICONIZED, Panel.LAST_DESELECTED, Panel.LOCATION, Panel.MAXIMIZED, Panel.SELECTED, Panel.SIZE));
                desc.setData(m);
            }
        } catch (IllegalArgumentException | NullPointerException | ClassCastException x) {
            desc.setOpen(false);
        }
        return desc;
    }

}
