package org.lsst.ccs.gconsole.plugins.trending;

import java.io.Serializable;
import java.util.*;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.plotter.DefaultPage;
import org.freehep.jas.services.PlotRegion;
import org.freehep.jas.services.Plotter;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelType;
import org.lsst.ccs.gconsole.jas3.JasPanelManager;

/**
 *
 * @author onoprien
 */
public class TrendingPanel extends DefaultPage {

// -- Fields : -----------------------------------------------------------------
    
    private final LsstTrendingPlugin plugin;
    private EnumMap<Panel,Object> prop;
    
    private volatile long lastRefresh;

// -- Life cycle : -------------------------------------------------------------
    
    public TrendingPanel(LsstTrendingPlugin plugin, String title) {
        super(((Studio)Application.getApplication()), plugin.getPlotFactory(), title);
        this.plugin = plugin;
        createRegions(1, 1);
    }
    
    public TrendingPanel(LsstTrendingPlugin plugin, Map<Panel,?> properties) {
        this(plugin, properties.get(Panel.TITLE).toString());
        prop = new EnumMap<>(properties);
    }
    

// -- Getters & Setters : ------------------------------------------------------

    public long getLastRefresh() {
        return lastRefresh;
    }

    public void setLastRefresh(long lastRefresh) {
        this.lastRefresh = lastRefresh;
    }
    
    
// -- Showing pages : ----------------------------------------------------------

  @Override
  public void showPage() {
    if (context == null) {
      if (prop == null) {
        prop = new EnumMap<>(Panel.class);
      }
      prop.put(Panel.TITLE, title());
      prop.put(Panel.GROUP, plugin.PANEL_GROUP);
      prop.put(Panel.ICON, histogramIcon);
      prop.put(Panel.TYPE, PanelType.DATA);
      JasPanelManager panMan = (JasPanelManager) plugin.getConsole().getPanelManager();
      panMan.open(this, prop);
      prop = null;
      context = panMan.getContext(this);
    } else {
      plugin.getConsole().getPanelManager().set(this, Panel.SELECTED, true);
    }
  }

    
// -- Responding to page events : ----------------------------------------------
    
    @Override
    public boolean close() {
        boolean out = super.close();
        if (out) {
            plugin.closePage(this);
        }
        return out;
    }
    
    
// -- Saving/Restoring : -------------------------------------------------------
    
    Descriptor save() {
        Descriptor desc = new Descriptor();
        desc.setTitle(title());
        desc.setRows(rows());
        desc.setColumns(columns());
        int n = numberOfRegions();
        ArrayList<TrendPlotter.Descriptor> plotterDescriptors = new ArrayList<>(n);
        for (int i=0; i<n; i++) {
            PlotRegion region = region(i);
            if (region != null) {
                Plotter plotter = region.currentPlot();
                if (plotter != null && plotter instanceof TrendPlotter) {
                    TrendPlotter.Descriptor plotterDescriptor = ((TrendPlotter)plotter).save();
                    if (plotterDescriptor != null) {
                        plotterDescriptors.add(plotterDescriptor);
                    }
                }
            }
        }
        desc.setPlotters(plotterDescriptors.toArray(new TrendPlotter.Descriptor[0]));
        boolean docked = (Boolean) plugin.getConsole().getPanelManager().get(this, Panel.DOCKED);
        if (!docked) {
            desc.setProperties(plugin.getConsole().getPanelManager().get(this, 
                    EnumSet.of(Panel.DEVICE, Panel.DOCKED, Panel.ICONIZED, Panel.LAST_DESELECTED, Panel.LOCATION, Panel.MAXIMIZED, Panel.SELECTED, Panel.SIZE)));
        }
        return desc;
    }
    
    void restore(Descriptor desc) {
        HashMap<String, Serializable> properties = desc.getProperties();
        if (properties != null) {
            prop = new EnumMap<>(Panel.class);
            prop.put(Panel.DOCKED, false);
            properties.forEach((key, value) -> prop.put(Panel.valueOf(key), value));
        }
        int rows = desc.getRows();
        int columns = desc.getColumns();
        if (rows != 1 || columns != 1) {
            createRegions(columns, rows);
        }
        int i = 0;
        for (TrendPlotter.Descriptor plotterDescriptor : desc.getPlotters()) {
            TrendPlotter plotter = plugin.create();
            plugin.showPlotter(plotter, region(i++));
            plotter.restore(plotterDescriptor);
        }
    }
    
    static public class Descriptor implements Serializable {

        private String title;
        private int rows;
        private int columns;
        private TrendPlotter.Descriptor[] plotters;
        private HashMap<String, Serializable> properties;

        public TrendPlotter.Descriptor[] getPlotters() {
            return plotters;
        }

        public void setPlotters(TrendPlotter.Descriptor[] plotters) {
            this.plotters = plotters;
        }

        public TrendPlotter.Descriptor getPlotters(int index) {
            return this.plotters[index];
        }

        public void setPlotters(int index, TrendPlotter.Descriptor plotters) {
            this.plotters[index] = plotters;
        }

        public int getColumns() {
            return columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public int getRows() {
            return rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public HashMap<String, Serializable> getProperties() {
            return properties;
        }

        public void setProperties(HashMap<String, Serializable> properties) {
            this.properties = properties;
        }
        
    }
    
}
