/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.util.waitcursor;

import junit.framework.TestCase;
import org.freehep.jas.util.waitcursor.DelayTimer;
import org.freehep.jas.util.waitcursor.DelayTimerCallback;

public class DelayTimerTest
extends TestCase {
    private static final int TIMEOUT = 100;
    private static final int BUFFER = 20;
    private static final int MORE_THAN_HALF = 60;
    private DelayTimer timer;
    private TestDelayTimerCallback callback;

    public DelayTimerTest(String name) {
        super(name);
    }

    public void setUp() {
        this.callback = new TestDelayTimerCallback();
        this.timer = new DelayTimer(this.callback, 100L);
    }

    public void tearDown() {
        this.timer.quit();
    }

    public void testMishMash() {
        this.timer.startTimer();
        this.sleep(60L);
        this.timer.startTimer();
        this.sleep(60L);
        this.timer.stopTimer();
        this.sleep(60L);
        this.timer.startTimer();
        this.timer.stopTimer();
        this.timer.stopTimer();
        this.sleep(60L);
        this.timer.startTimer();
        this.timer.startTimer();
        DelayTimerTest.assertEquals((String)"no event yet", (int)0, (int)this.callback.getTriggerCount());
        this.sleep(120L);
        this.timer.stopTimer();
        DelayTimerTest.assertEquals((String)"got event yet", (int)1, (int)this.callback.getTriggerCount());
    }

    public void testNoTriggerIfTooShort() {
        this.timer.startTimer();
        DelayTimerTest.assertEquals((String)"no trigger if too fast", (int)0, (int)this.callback.getTriggerCount());
        this.timer.stopTimer();
        this.sleep(120L);
        DelayTimerTest.assertEquals((String)"no trigger after stop", (int)0, (int)this.callback.getTriggerCount());
    }

    public void testNotStarted() {
        this.sleep(120L);
        DelayTimerTest.assertEquals((String)"no trigger without start()", (int)0, (int)this.callback.getTriggerCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStopTimerHappensAfterTrigger() {
        FancyTestDelayTimerCallback callback = new FancyTestDelayTimerCallback();
        this.timer = new DelayTimer(callback, 100L);
        this.timer.startTimer();
        this.sleep(120L);
        DelayTimerTest.assertTrue((String)"timer is in trigger", (boolean)callback.inTrigger);
        DelayTimerTest.assertTrue((String)"timer has not thrown exception", (!callback.exception ? 1 : 0) != 0);
        DelayTimerTest.assertTrue((String)"timer is not out of trigger", (!callback.outOfTrigger ? 1 : 0) != 0);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DelayTimerTest.this.timer.stopTimer();
            }
        };
        Thread testThread = new Thread(runnable, "test thread");
        testThread.start();
        this.sleep(120L);
        DelayTimerTest.assertTrue((String)"stopTimer() has not returned", (boolean)testThread.isAlive());
        FancyTestDelayTimerCallback fancyTestDelayTimerCallback = callback;
        synchronized (fancyTestDelayTimerCallback) {
            callback.notify();
        }
        this.sleep(120L);
        DelayTimerTest.assertTrue((String)"timer has not thrown exception", (!callback.exception ? 1 : 0) != 0);
        DelayTimerTest.assertTrue((String)"timer is out of trigger", (boolean)callback.outOfTrigger);
        DelayTimerTest.assertTrue((String)"stopTimer() has returned", (!testThread.isAlive() ? 1 : 0) != 0);
    }

    public void testTimerOnlyTriggersOneEvent() {
        this.timer.startTimer();
        this.sleep(120L);
        DelayTimerTest.assertEquals((String)"timer triggered event", (int)1, (int)this.callback.getTriggerCount());
        this.sleep(120L);
        DelayTimerTest.assertEquals((String)"timer did not trigger another event", (int)1, (int)this.callback.getTriggerCount());
        this.timer.stopTimer();
    }

    public void testTimerRestarts() {
        this.timer.startTimer();
        this.sleep(60L);
        this.timer.startTimer();
        this.sleep(60L);
        this.timer.stopTimer();
        DelayTimerTest.assertEquals((String)"timer is restarted on calls to start()", (int)0, (int)this.callback.getTriggerCount());
    }

    public void testTimerStopsTwice() {
        this.timer.startTimer();
        this.timer.stopTimer();
        this.timer.stopTimer();
        this.sleep(120L);
        DelayTimerTest.assertEquals((String)"timer did not trigger event", (int)0, (int)this.callback.getTriggerCount());
    }

    public void testTimerTriggersThenStops() {
        this.timer.startTimer();
        this.sleep(120L);
        this.timer.stopTimer();
        this.sleep(120L);
        DelayTimerTest.assertEquals((String)"timer triggered event", (int)1, (int)this.callback.getTriggerCount());
    }

    public void testTriggerTrigger() {
        this.timer.startTimer();
        this.sleep(120L);
        DelayTimerTest.assertEquals((String)"timer triggered first event", (int)1, (int)this.callback.getTriggerCount());
        this.timer.startTimer();
        this.sleep(120L);
        DelayTimerTest.assertEquals((String)"timer triggered second event", (int)2, (int)this.callback.getTriggerCount());
        this.sleep(120L);
        this.timer.stopTimer();
        DelayTimerTest.assertEquals((String)"timer did not trigger another event", (int)2, (int)this.callback.getTriggerCount());
    }

    public void testTriggers() {
        this.timer.startTimer();
        this.sleep(120L);
        this.timer.stopTimer();
        this.timer.stopTimer();
        DelayTimerTest.assertEquals((String)"timer triggered only 1 event", (int)1, (int)this.callback.getTriggerCount());
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class TestDelayTimerCallback
    implements DelayTimerCallback {
        private int triggerCount;

        private TestDelayTimerCallback() {
        }

        public int getTriggerCount() {
            return this.triggerCount;
        }

        @Override
        public void trigger() {
            ++this.triggerCount;
        }
    }

    private class FancyTestDelayTimerCallback
    implements DelayTimerCallback {
        public boolean exception;
        public boolean inTrigger;
        public boolean outOfTrigger;

        private FancyTestDelayTimerCallback() {
        }

        @Override
        public synchronized void trigger() {
            this.inTrigger = true;
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                this.exception = true;
                e.printStackTrace();
            }
            finally {
                this.outOfTrigger = true;
            }
        }
    }
}

