package org.lsst.ccs.gconsole.services.persist;

import java.awt.Component;

/**
 * Interface to be implemented by classes that allow users to modify a {@link Persistable} instance.
 *
 * @author onoprien
 */
public interface Editor {
    
    /**
     * Takes user input and modifies the provided {@code Persistable} instance.
     * Returns {@code null} if the user cancels editing.
     * Throws {@code RuntimeException} if editing fails for any other reason.
     * 
     * @param in Instance to be edited.
     * @param title User-interaction dialog title, or {@code null} if the default title should be used.
     * @param parent Graphical component to be use as a parent for user-interaction dialog(s).
     * @return Modified instance. This may or may not be the same instance that was passed to this method as {@code in} parameter.
     */
    Persistable edit(Persistable in, String title, Component parent);
    
}
