package org.lsst.ccs.gconsole.agent.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;

/**
 * Filter that selects subsystem state channels.
 *
 * @author onoprien
 */
public class Configuration extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    private final String name;
    private final List<String> agents;

// -- Life cycle : -------------------------------------------------------------
    
    @Create(category = "AgentChannelsFilter",
            name = "Configuration",
            path = "Built-In/Configuration",
            description = "Channels filter that selects subsystem configuration channels.")
    public Configuration(
            @Par(def = "Configuration", desc = "Filter name.") String name,
            @Par(def = Par.NULL, desc = "List of subsystems accepted by this filter. If null, all subsystems are accepted.") List<String> agents)
    {
        this.name = name;
        this.agents = agents == null ? null : new ArrayList<>(agents);
    }
    
// -- Implementing filter : ----------------------------------------------------

    @Override
    public List<String> getDisplayPath(String originPath) {
        String displayPath = originPath.replaceFirst("/configuration/", "/");
        return Collections.singletonList(displayPath);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath.replaceFirst("/", "/configuration/");
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("/configuration/");
    }

    @Override
    public List<String> getAgents() {
        return agents == null ? null : Collections.unmodifiableList(agents);
    }

    @Override
    public String getName() {
        return name;
    }

}

