package org.lsst.ccs.gconsole.util.refrig;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;

/**
 * Stub for the refrigeration GUI.
 *
 * @author onoprien
 */
//@Plugin(name = "LSST CCS Refrigeration GUI",
//        id="image-view-demo",
//        description = "LSST CCS refrigeration subsystem GUI.")
public class RefrigerationPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    private final OptionalPage optPageFront;
    private FrontPage frontPage;
    private final OptionalPage optPageVacuum;
    private VacuumPage vacuumPage;

// -- Life cycle : -------------------------------------------------------------
    
    public RefrigerationPlugin() {
        
        optPageFront = new OptionalPage() {
            @Override
            public String getPage(AgentInfo agent) {
                return agent.hasAgentProperty("cryo") ? "CCS Subsystems/"+ agent.getName() +":1/Main" : null;
            }
            @Override
            public JComponent open(AgentInfo agent, JComponent existingComponent) {
                frontPage = new FrontPage(RefrigerationPlugin.this, agent);
                return frontPage.getView().getPanel();
            }
            @Override
            public void opened(String page) {
                frontPage.getView().install();
                frontOpened();
            }
            @Override
            public void closed(String page) {
                frontClosed();
                frontPage.getView().uninstall();
            }
        };
        
        optPageVacuum = new OptionalPage() {
            @Override
            public boolean isAutoOpen() {
                return false;
            }
            @Override
            public String getPage(AgentInfo agent) {
                return agent.hasAgentProperty("cryo") ? "CCS Subsystems/"+ agent.getName() +":2/Vacuum" : null;
            }
            @Override
            public JComponent open(AgentInfo agent, JComponent existingComponent) {
                vacuumPage = new VacuumPage();
                return vacuumPage.getView().getPanel();
            }
            @Override
            public void opened(String page) {
                vacuumPage.getView().install();
            }
            @Override
            public void closed(String page) {
                vacuumPage.getView().uninstall();
            }
        };

    }
    
    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        OptionalPage.getService().add(optPageFront);
        OptionalPage.getService().add(optPageVacuum);
    }

    @Override
    public void stop() {
        OptionalPage.getService().remove(optPageFront);
        OptionalPage.getService().remove(optPageVacuum);
    }
    
    void frontOpened() {
    }
    
    void frontClosed() {
    }
    
    
// -- Ops : --------------------------------------------------------------------
    
    void setVacuumOpen(AgentInfo agent, boolean isOpen) {
        optPageVacuum.setOpen(agent, isOpen);
    }
    
}
