package org.lsst.ccs.gconsole.services.persist;

import java.lang.reflect.Parameter;
import org.lsst.ccs.gconsole.base.Console;

/**
 * {@link Creator} that wraps a {@link Persistable.Descriptor}.
 *
 * @author onoprien
 */
public class CreatorDescriptor implements Creator {

// -- Fields : -----------------------------------------------------------------
    
    private final Persistable.Descriptor descriptor;

// -- Life cycle : -------------------------------------------------------------
    
    public CreatorDescriptor(Persistable.Descriptor descriptor) {
        this.descriptor = descriptor;
    }
    
// -- Implement Creator : ------------------------------------------------------

    @Override
    public String getCategory() {
        return descriptor.getCreator().getCategory();
    }

    @Override
    public String getPath() {
        return descriptor.getPath();
    }

    @Override
    public String getName() {
        return descriptor.getName();
    }

    @Override
    public String getDescription() {
        return descriptor.getDescription();
    }

    @Override
    public Parameter[] getParameters() {
        return new Parameter[0];
    }

    @Override
    public String[] getParameterDescriptions() {
        return new String[0];
    }

    @Override
    public Persistable make(Object... parameters) throws Exception {
        if (parameters.length != 0) throw new IllegalArgumentException();
        PersistenceService service = (PersistenceService) Console.getConsole().getConsoleLookup().lookup(PersistenceService.class);
        return service.make(descriptor);
    }

    @Override
    public Persistable make(String... parametersAsStrings) throws Exception {
        if (parametersAsStrings.length != 0) throw new IllegalArgumentException();
        return make(new Object[0]);
    }

}
