package org.lsst.ccs.gconsole.plugins.tracer;

/**
 * User-defined message filter.
 * Filters of this type are either read from a file or defined by the console user 
 * through the filter editor dialog.
 *
 * @author onoprien
 */
public class UserFilter implements MessageFilter {

// -- Private parts : ----------------------------------------------------------
    
    private final String name;
    final TracerFilter[] filters;
    final boolean[] or;

// -- Construction and initialization : ----------------------------------------
    
    /**
     * Constructs a filter.
     * Objects supplied to this constructor will be owned by this filter.
     * 
     * @param name Name of this filter.
     * @param filters The sequence of filters.
     * @param or OR flags for filters in the sequence.
     */
    public UserFilter(String name, TracerFilter[] filters, boolean[] or) {
        this.name = name;
        this.filters = filters;
        this.or = or;
    }

// -- Implementing MessageFilter : ---------------------------------------------

    @Override
    public FilteredMessage test(FilteredMessage filteredMessage) {
        boolean failedOR = false;
        boolean goodOR = false;
        for (int i=0; i<filters.length; i++) {
            TracerFilter filter = filters[i];
            if (or[i]) {
                if (goodOR) continue;
                FilteredMessage fm = filter.test(filteredMessage);
                if (fm == null) {
                    failedOR = true;
                } else {
                    failedOR = false;
                    goodOR = true;
                    filteredMessage = fm;
                }
            } else {
                if (failedOR) return null;
                filteredMessage = filter.test(filteredMessage);
                if (filteredMessage == null) return null;
                goodOR = false;
            }
        }
        return failedOR ? null : filteredMessage;
    }
    
    @Override
    public String getPath() {
        return name;
    }

}
