package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.services.persist.Savable;

/**
 * Interface to be implemented by all types of command browsers.
 *
 * @author onoprien
 */
public interface Browser extends Savable {
        
    ImageIcon ICON_UNLOCKED = new ImageIcon(Browser.class.getResource("ic_lock_open_black_18dp.png"), "unlocked");
    ImageIcon ICON_LOCKED = new ImageIcon(Browser.class.getResource("ic_lock_black_18dp.png"), "locked");
    ImageIcon ICON_UNAVAILABLE = null;
    
    /**
     * Returns the name of this command browser.
     * @return Browser name.
     */
    String getName();
    
    /**
     * Initializes the browser if necessary, and returns its root graphics component.
     * @return Root graphics component for this browser.
     */
    JComponent getPanel();
    
    /**
     * Releases resources and shuts down this browser.
     */
    void shutdown();
    
    
// -- Savin/restoring : --------------------------------------------------------
    
    public class Descriptor implements Serializable {

        private String name;
        private String agent;
        private AgentPanel.Descriptor agentPanel;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAgent() {
            return agent;
        }

        public void setAgent(String agent) {
            this.agent = agent;
        }

        public AgentPanel.Descriptor getAgentPanel() {
            return agentPanel;
        }

        public void setAgentPanel(AgentPanel.Descriptor agentPanel) {
            this.agentPanel = agentPanel;
        }

    }
    
}
