/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;

@Plugin(name="LSST Rest Plugin", id="rest", description="Plugin that handles connection to the REST server.")
public class LsstRestPlugin
extends ConsolePlugin {
    public static final String SERVER_PROPERTY = "server";
    public static final String PORT_PROPERTY = "port";
    public static final String CONNECT_ON_STARTUP_PROPERTY = "connectOnStartup";
    private final Client client;
    private WebResource service;
    private final ReentrantLock lock = new ReentrantLock();

    public LsstRestPlugin() {
        this.client = Client.create((ClientConfig)new DefaultClientConfig());
    }

    @Override
    public void initialize() {
        this.getServices().addProperty(SERVER_PROPERTY, "localhost");
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, "URL", "Server: ${server#history=5}");
        this.getServices().addProperty(PORT_PROPERTY, 8080);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, "URL", "Port: ${port}");
        this.getServices().addProperty(CONNECT_ON_STARTUP_PROPERTY, true);
        this.getServices().addPreference(new String[]{"LSST", "Servers", "REST"}, null, "${connectOnStartup} Connect on startup.");
    }

    @Override
    public void start() {
        if (((Boolean)this.getServices().getProperty(CONNECT_ON_STARTUP_PROPERTY)).booleanValue()) {
            this.refreshConnection();
        }
    }

    @Override
    public void shutdown() {
        this.client.destroy();
    }

    @Override
    public void propertiesChanged(Object source, Map<String, Object> changes) {
        Set<String> keys = changes.keySet();
        if (keys.contains(SERVER_PROPERTY) || keys.contains(PORT_PROPERTY)) {
            this.refreshConnection();
        }
    }

    public void refreshConnection() {
        if (this.lock.isLocked()) {
            return;
        }
        Thread t = new Thread(this::connect, "REST Connector");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        if (this.lock.tryLock()) {
            try {
                FreeHEPLookup lookup = this.getConsole().getConsoleLookup();
                if (this.service != null) {
                    lookup.remove((Object)this.service, "dataserver");
                    this.service = null;
                }
                String restFullUrl = this.getURL();
                this.getConsole().getLogger().fine((Object)("Connecting to REST server " + restFullUrl));
                WebResource serv = this.client.resource(restFullUrl).path("dataserver");
                try {
                    serv.head();
                    lookup.add((Object)serv, "dataserver");
                    this.service = serv;
                    this.getConsole().getLogger().fine((Object)"REST server connection successful.");
                }
                catch (RuntimeException e) {
                    this.getConsole().getLogger().warn((Object)("Unable to connect to REST server at " + restFullUrl), (Throwable)e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private String getURL() {
        String server = null;
        try {
            server = this.getServices().getProperty(SERVER_PROPERTY).toString();
            int port = (Integer)this.getServices().getProperty(PORT_PROPERTY);
            return String.format("http://%s:%d/rest/data", server, port);
        }
        catch (RuntimeException x) {
            this.getConsole().getLogger().warn((Object)("Invalid server " + server + " or port " + this.getServices().getProperty(PORT_PROPERTY)));
            throw x;
        }
    }
}

