package org.lsst.ccs.gconsole.util.tree;

import java.util.Comparator;
import java.util.Map;

/**
 *
 * @author onoprien
 */
public enum Sort implements Comparator<String> {
    
    NONE("Original order"),
    
    ALPHABETIC_LEAVES_LAST("Alphabetic, leaves last") {
        @Override
        public int compare(String path1, String path2) {
            return alphaCompare(path1, path2, true);
        }
    },
    
    ALPHABETIC_LEAVES_FIRST("Alphabetic, leaves first") {
        @Override
        public int compare(String path1, String path2) {
            return alphaCompare(path1, path2, false);
        }
    },
    
    ALPHABETIC("Alphabetic") {
        @Override
        public int compare(String path1, String path2) {
            return path1.compareTo(path2);
        }
    };
    
    private final String humanReadable;
    
    Sort(String humanReadable) {
        this.humanReadable = humanReadable;
    }

    @Override
    public int compare(String path1, String path2) {
        throw new UnsupportedOperationException("Value "+ this +" does not provide Comparator.");
    }

    @Override
    public String toString() {
        return humanReadable;
    }
    
    static public Sort parse(String humanReadable) {
        for (Sort sort : Sort.values()) {
            if (sort.toString().equals(humanReadable)) return sort;
        }
        return null;
    }
    
    static private int alphaCompare(String path1, String path2, boolean leavesLast) {
            String[] p1 = path1.split("/+");
            String[] p2 = path2.split("/+");
            int out = 0;
            int n = Math.max(p1.length, p2.length);
            for (int i = 0; i < n; i++) {
                if (i == p1.length) return leavesLast ? 1 : -1;
                if (i == p2.length) return leavesLast ? -1 : 1;
                if (out != 0) return out;
                out = p1[i].compareTo(p2[i]);
            }
            return out;
    }
}
