package org.lsst.ccs.gconsole.plugins.monitor;

import org.lsst.ccs.gconsole.agent.AgentChannel;

/**
 * Default implementation of {@link ChannelHandle}.
 *
 * @author onoprien
 */
public class DefaultChannelHandle implements ChannelHandle {

// -- Fields : -----------------------------------------------------------------

    String path;
    AgentChannel channel;
    Updatable view;


// -- Life cycle : -------------------------------------------------------------

    public DefaultChannelHandle(String path, AgentChannel channel, Updatable view) {
        this.path = path;
        this.channel = channel;
        this.view = view;
    }

    
// -- Getters and setters : ----------------------------------------------------

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public AgentChannel getChannel() {
        return channel;
    }

    @Override
    public Updatable getTarget() {
        return view;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public void setChannel(AgentChannel channel) {
        this.channel = channel;
    }

    @Override
    public void setTarget(Updatable view) {
        this.view = view;
    }

}
