package org.lsst.ccs.gconsole.plugins.jms;

import java.util.logging.Logger;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.gconsole.plugins.rest.LsstRestPlugin;

/**
 * This plugin allows use of JMS protocol instead of the default JGroups protocol.
 * @author tonyj
 */
public class LsstJmsPlugin extends Plugin {

    private static final Logger logger = Logger.getLogger(LsstRestPlugin.class.getName());
    private JmsPreferences prefs;
    private Studio studio;
    

    @Override
    protected void init() {
        logger.finest("LsstJmsPlugin created");
        studio = getApplication();        
        prefs = new JmsPreferences(studio);
        
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add(new JmsPreferencesTopic(prefs));
    }
}
