package org.lsst.ccs.gconsole.plugins.demo.persist;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

/**
 * Tester plugin for persistence service.
 *
 * @author onoprien
 */
//@Plugin(name = "Persistance Service Demo",
//        id="persist-demo",
//        description = "Persistance Service demo plugin")
public class PersistPlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------
        
    @Override
    public void initialize() {
        
        Action actDemo1 = new AbstractAction("Create") {
            @Override
            public void actionPerformed(ActionEvent e) {
                PersistenceService service = (PersistenceService) getConsole().getConsoleLookup().lookup(PersistenceService.class);
                Persistable filter = service.make(null, "title", null, "test");
                System.out.println(filter);
                filter = service.make(filter.save(), "title", null, "test");
                System.out.println(filter);
                filter = service.make(filter.save());
                System.out.println(filter);
            }
        };
        actDemo1.putValue(Action.SELECTED_KEY, false);
        getServices().addMenu(actDemo1, "Demo", "Persistence");

    }

}
