package org.lsst.ccs.gconsole.plugins.demo.life;

import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.ConsolePlugin;

/**
 * 
 *
 * @author onoprien
 */
//@Plugin(name = "Life cycle Demo Plugin",
//        id="life-demo",
//        description = "Tester for startup/shutdown.")
public class LifeCyclePlugin extends ConsolePlugin {

// -- Fields : -----------------------------------------------------------------
    
    private volatile StringBuilder hist = new StringBuilder();

// -- Life cycle : -------------------------------------------------------------

    @Override
    public void initialize() {
        super.initialize();
        hist.append("init+");
        System.out.println(hist);
        try {Thread.sleep(2000);} catch (InterruptedException x) {}
    }

    @Override
    public void start() {
        super.start();
        hist.append("start+");
        System.out.println(hist);
        try {Thread.sleep(2000);} catch (InterruptedException x) {}
    }

    @Override
    public void stop() {
        super.stop();
        hist.append("stop+");
        System.out.println(hist);
        try {Thread.sleep(2000);} catch (InterruptedException x) {}
    }

    @Override
    public void shutdown() {
        super.shutdown();
        hist.append("shut+");
        System.out.println(hist);
        try {Thread.sleep(2000);} catch (InterruptedException x) {}
    }

    @Override
    public ComponentDescriptor save() {
        hist.append("save+");
        System.out.println(hist);
        try {Thread.sleep(2000);} catch (InterruptedException x) {}
        return super.save();
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        hist.append("rest+");
        System.out.println(hist);
        try {Thread.sleep(2000);} catch (InterruptedException x) {}
        return super.restore(storageBean, lastRound);
    }

}
