package org.lsst.ccs.gconsole.plugins.commandbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.*;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.Const;

/**
 * 
 *
 * @author onoprien
 */
public final class FilterDialog extends JDialog {

// -- Fields : -----------------------------------------------------------------
    
    private final BrowserFull.Filter filter;

// -- Life cycle : -------------------------------------------------------------
    
    private FilterDialog(BrowserFull.Filter filter, Component parentComponent) {
        super(parentComponent == null ? null : SwingUtilities.getWindowAncestor(parentComponent), "Filter target subsystems", Dialog.ModalityType.APPLICATION_MODAL);
        this.filter = filter;
        
        Box mainPanel = Box.createVerticalBox();
        add(new JScrollPane(mainPanel), BorderLayout.CENTER);
        mainPanel.add(Box.createRigidArea(Const.VDIM));
        
        GridLayout gl = new GridLayout(0,2);
        gl.setHgap(10);
        JPanel typePanel = new JPanel(gl);
        mainPanel.add(typePanel);
        typePanel.setBorder(BorderFactory.createTitledBorder("Type:"));
        for (AgentInfo.AgentType type : AgentInfo.AgentType.values()) {
            typePanel.add(new TypeBox(type));
        }
        
        mainPanel.add(Box.createRigidArea(Const.VDIM));
        
        Box namePanel = Box.createVerticalBox();
        mainPanel.add(namePanel);
        namePanel.setBorder(BorderFactory.createTitledBorder("Name:"));
        namePanel.add(new JLabel("<html>Comma-separated agent names:"));
        namePanel.add(Box.createRigidArea(Const.VDIM));
        namePanel.add(new NameField());
        
        mainPanel.add(Box.createRigidArea(Const.VDIM));
        
        Box groupPanel = Box.createVerticalBox();
        mainPanel.add(groupPanel);
        groupPanel.setBorder(BorderFactory.createTitledBorder("Group:"));
        groupPanel.add(new JLabel("<html>Comma-separated agent groups:"));
        groupPanel.add(Box.createRigidArea(Const.VDIM));
        groupPanel.add(new GroupField());
        
        mainPanel.add(Box.createRigidArea(Const.VDIM));
        
        Box propertiesPanel = Box.createVerticalBox();
        mainPanel.add(propertiesPanel);
        propertiesPanel.setBorder(BorderFactory.createTitledBorder("Properties:"));
        propertiesPanel.add(new JLabel("<html>Comma-separated list of agent properties in key[=value] format. \"null\" value indicates testing for the absence of the property."));
        propertiesPanel.add(Box.createRigidArea(Const.VDIM));
        propertiesPanel.add(new PropertiesField());

        mainPanel.add(Box.createRigidArea(Const.VDIM));
        mainPanel.add(Box.createVerticalGlue());
        
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(e -> {
            dispose();
            filter.restore();
            filter.apply();
        });
        buttonPanel.add(cancel);
        buttonPanel.add(Box.createRigidArea(Const.HDIM));
        JButton ok = new JButton("  OK  ");
        ok.addActionListener(e -> {
            dispose();
            filter.save();
        });
        buttonPanel.add(ok);
        buttonPanel.add(Box.createRigidArea(Const.HDIM));
        add(buttonPanel, BorderLayout.SOUTH);
    }

    static void show(BrowserFull.Filter filter, Component parentComponent) {
        if (parentComponent != null) {
            parentComponent = SwingUtilities.getWindowAncestor(parentComponent);
        }
        FilterDialog dialog = new FilterDialog(filter, parentComponent);
        dialog.setSize(dialog.getPreferredSize());
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        dialog.setVisible(true);
    }
    
    
// -- Local classes : ----------------------------------------------------------
    
    private final class TypeBox extends JCheckBox {
        private final AgentInfo.AgentType type;
        TypeBox(AgentInfo.AgentType type) {
            super(type.displayName());
            this.type = type;
            setSelected(filter.types == null || filter.types.contains(type));
            addActionListener(e -> {
                if (isSelected()) {
                    filter.types.add(this.type);
                    if (filter.types.size() == AgentInfo.AgentType.values().length) filter.types = null;
                } else {
                    if (filter.types == null) filter.types = EnumSet.allOf(AgentInfo.AgentType.class);
                    filter.types.remove(this.type);
                }
                filter.apply();
            });
        }
    }
    
    private final class NameField extends JTextField {
        NameField() {
            super(20);
            if (filter.names != null) {
                setText(String.join(",", filter.names));
            }
            setMaximumSize(new Dimension(Integer.MAX_VALUE, getPreferredSize().height));
            addCaretListener(e -> {
                String text = getText();
                if (text.trim().isEmpty()) {
                    filter.names = null;
                } else {
                    String[] ss = text.split(",");
                    filter.names = new ArrayList<>(ss.length);
                    for (String s : ss) {
                        filter.names.add(s.trim());
                    }
                }
                filter.apply();
            });
        }
    }
    
    private final class GroupField extends JTextField {
        GroupField() {
            super(20);
            if (filter.groups != null) {
                setText(String.join(",", filter.groups));
            }
            setMaximumSize(new Dimension(Integer.MAX_VALUE, getPreferredSize().height));
            addCaretListener(e -> {
                String text = getText();
                if (text.trim().isEmpty()) {
                    filter.groups = null;
                } else {
                    String[] ss = text.split(",");
                    filter.groups = new ArrayList<>(ss.length);
                    for (String s : ss) {
                        filter.groups.add(s.trim());
                    }
                }
                filter.apply();
            });
        }
    }
    
    private final class PropertiesField extends JTextField {
        PropertiesField() {
            super(20);
            setMaximumSize(new Dimension(Integer.MAX_VALUE, getPreferredSize().height));
            if (filter.properties != null) {
                ArrayList<String> ss = new ArrayList<>(filter.properties.size());
                filter.properties.forEach((key,value) -> {
                    if (value == null) {
                        key += "=null";
                    } else if (!value.isEmpty()) {
                        key += "="+ value;
                    }
                    ss.add(key);
                });
                setText(String.join(",", ss));
            }
            addCaretListener(e -> {
                String text = getText();
                if (text.trim().isEmpty()) {
                    filter.properties = null;
                } else {
                    String[] ss = text.split(",");
                    filter.properties = new HashMap<>();
                    for (String s : ss) {
                        String[] sss = s.split("=");
                        if (sss.length > 0) {
                            String key = sss[0].trim();
                            if (sss.length > 1) {
                                String value = sss[1].trim();
                                if (value.equalsIgnoreCase("null")) value = null;
                                filter.properties.putIfAbsent(key, value);
                            } else {
                                filter.properties.putIfAbsent(key, "");
                            }
                        }
                    }
                }
                filter.apply();
            });
        }
    }


}
