package org.lsst.ccs.gconsole.base.panel;

import java.awt.Component;
import java.util.EventObject;

/**
 * An event fired by {@link PanelManager}.
 *
 * @author onoprien
 */
public class PanelEvent extends EventObject {

// -- Fields : -----------------------------------------------------------------
    
    private final String key;
    private final Object oldValue;
    private final Object newValue;
    

// -- Life cycle : -------------------------------------------------------------
    
    public PanelEvent(Component source, Object key, Object oldValue, Object newValue) {
        super(source);
        this.key = key.toString();
        this.oldValue = oldValue;
        this.newValue = newValue;
    }
    
    
// -- Getters : ----------------------------------------------------------------
    
    @Override
    public Component getSource() {
        return (Component) source;
    }
     
    public String getPropertyName() {
        return key;
    }
    
    public Object getOldValue() {
        return oldValue;
    }
   
    public Object getNewValue() {
        return newValue;
    }
    
    public boolean hasKey(Object key) {
        return this.key.equals(key.toString());
    }
    
    
// -- Printing : ---------------------------------------------------------------

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Panel event: key:").append(key).append(", was:").append(oldValue).append(", now:").append(newValue);
        sb.append(". From ").append(getSource());
        return sb.toString();
    }

}
