package org.lsst.ccs.gconsole.agent.filter;

import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.services.persist.Persistable;

/**
 * Adapter to simplify implementing {@link AgentChannelsFilter}.
 * Provides machinery for handling listeners and minimal implementation of {@code Persistable}.
 *
 * @author onoprien
 */
abstract public class AbstractChannelsFilter implements AgentChannelsFilter, Persistable {

// -- Fields : -----------------------------------------------------------------
    
    private final CopyOnWriteArrayList<AgentChannelsFilter.Listener> listeners = new CopyOnWriteArrayList<>();
    protected Descriptor descriptor = new Descriptor();

// -- Handling listeners : -----------------------------------------------------
    
    @Override
    public void addListener(AgentChannelsFilter.Listener listener) {
        listeners.addIfAbsent(listener);
    }
    
    @Override
    public void removeListener(AgentChannelsFilter.Listener listener) {
        listeners.remove(listener);
    }
    
    protected void notifyListeners() {
        AgentChannelsFilter.Event event = new AgentChannelsFilter.Event(AbstractChannelsFilter.this);
        listeners.forEach(listener -> listener.filterChanged(event));
    }
    
    
// -- Saving/restoring : -------------------------------------------------------

    @Override
    public Descriptor getDescriptor() {
        return descriptor;
    }

}
