/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.optpage;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.agent.AgentStatusListener;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;

class OptionalPageHandler
implements AgentStatusListener {
    private final OptionalPage descriptor;
    private final HashMap<String, Page> path2page = new HashMap();
    private boolean stopped = true;
    private HashMap<String, Boolean> state;

    OptionalPageHandler(OptionalPage descriptor) {
        this.descriptor = descriptor;
    }

    void start() {
        this.stopped = false;
        this.onConnect(null);
        Console.getConsole().getStatusAggregator().addListener(this, null, Collections.emptyList());
    }

    void stop() {
        Console.getConsole().getStatusAggregator().removeListener(this);
        new ArrayList<Page>(this.path2page.values()).forEach(page -> page.uninstall());
        this.stopped = true;
    }

    OptionalPage getDescriptor() {
        return this.descriptor;
    }

    void setState(HashMap<String, Boolean> state) {
        this.state = state;
    }

    @Override
    public void connect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.onConnect(event.getSource()));
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        SwingUtilities.invokeLater(() -> this.onDisconnect(event.getSource()));
    }

    private void onConnect(AgentInfo agent) {
        if (this.stopped) {
            return;
        }
        String path = this.getPath(agent);
        if (path == null) {
            return;
        }
        Page page = this.path2page.get(path);
        if (page == null) {
            page = new Page(path);
            page.install();
        }
        page.addAgent(agent);
    }

    private void onDisconnect(AgentInfo agent) {
        if (this.stopped) {
            return;
        }
        for (Page page : this.path2page.values()) {
            if (page.removeAgent(agent)) break;
        }
    }

    public HashMap<String, Boolean> save() {
        HashMap<String, Boolean> out = new HashMap<String, Boolean>();
        this.path2page.forEach((path, page) -> out.put((String)path, page.isOpen()));
        return out;
    }

    public void restore(HashMap<String, Boolean> state) {
        this.state = state;
        this.path2page.forEach((path, page) -> {
            Boolean open = (Boolean)state.get(path);
            if (open != null) {
                page.setOpen(open);
            }
        });
    }

    void setOpen(AgentInfo agent, boolean isOpen) {
        Page page = this.getPage(agent);
        if (page != null) {
            page.setOpen(isOpen);
        }
    }

    private String getPath(AgentInfo agent) {
        try {
            String name = this.descriptor.getPage(agent);
            if (name != null) {
                String path;
                if (name.trim().isEmpty()) {
                    name = agent.getName();
                }
                if ((path = this.descriptor.getPath()) != null) {
                    name = path + "/" + name;
                }
            }
            return name;
        }
        catch (RuntimeException x) {
            return null;
        }
    }

    private Page getPage(AgentInfo agent) {
        if (this.stopped) {
            return null;
        }
        String path = this.getPath(agent);
        if (path == null) {
            return null;
        }
        Page page = this.path2page.get(path);
        return page;
    }

    private class Page
    extends AbstractAction {
        private final String path;
        JComponent component;
        final ArrayList<AgentInfo> agents;

        Page(String path) {
            super(path.substring(path.lastIndexOf("/") + 1));
            this.agents = new ArrayList(1);
            this.path = path;
        }

        void install() {
            Boolean open = null;
            if (OptionalPageHandler.this.state != null) {
                open = (Boolean)OptionalPageHandler.this.state.get(this.path);
            }
            if (open == null) {
                open = OptionalPageHandler.this.descriptor.isAutoOpen();
            }
            this.putValue("SwingSelectedKey", open);
            OptionalPageHandler.this.path2page.put(this.path, this);
            Console.getConsole().addMenu(this, null, this.getMenuPath());
        }

        void uninstall() {
            Console.getConsole().removeMenu(this.path.split("/"));
            if (this.component != null) {
                Console.getConsole().getPanelManager().close(this.component);
            }
            OptionalPageHandler.this.path2page.remove(this.path);
        }

        void addAgent(AgentInfo agent) {
            this.agents.add(agent);
            if (this.isOpen()) {
                this.open(OptionalPageHandler.this.descriptor.open(agent, this.component));
            }
        }

        boolean removeAgent(AgentInfo agent) {
            Iterator<AgentInfo> it = this.agents.iterator();
            while (it.hasNext()) {
                AgentInfo a = it.next();
                if (a == null || !a.getName().equals(agent.getName())) continue;
                it.remove();
                boolean close = OptionalPageHandler.this.descriptor.agentDisconnected(a);
                if (close || !this.isOpen() && this.agents.isEmpty()) {
                    this.uninstall();
                }
                return true;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isOpen()) {
                this.component = null;
                for (AgentInfo agent : this.agents) {
                    this.open(OptionalPageHandler.this.descriptor.open(agent, this.component));
                }
            } else if (this.component != null) {
                Console.getConsole().getPanelManager().close(this.component);
            }
        }

        boolean isOpen() {
            return (Boolean)this.getValue("SwingSelectedKey");
        }

        void setOpen(boolean open) {
            boolean wasOpen = this.isOpen();
            if (open != wasOpen) {
                this.putValue("SwingSelectedKey", open);
                this.actionPerformed(null);
            }
            if (open && wasOpen && this.component != null) {
                Console.getConsole().getPanelManager().set(this.component, Panel.SELECTED, true);
            }
        }

        void open(JComponent component) {
            if (component == null) {
                return;
            }
            if (this.component != component) {
                if (this.component != null) {
                    PanelManager pm = Console.getConsole().getPanelManager();
                    pm.set(this.component, Panel.ON_CLOSE, null);
                    pm.close(this.component);
                }
                this.component = component;
                String title = component.getName();
                if (title == null) {
                    title = this.getValue("Name").toString();
                }
                TreeMap<Panel, Object> par = new TreeMap<Panel, Object>();
                par.put(Panel.TITLE, title);
                Consumer<JComponent> onClose = c -> this.close();
                par.put(Panel.ON_CLOSE, onClose);
                Console.getConsole().getPanelManager().open((Component)component, par);
            }
            OptionalPageHandler.this.descriptor.opened(this.path);
        }

        void close() {
            this.putValue("SwingSelectedKey", false);
            OptionalPageHandler.this.descriptor.closed(this.path);
            if (this.agents.isEmpty()) {
                this.uninstall();
            }
        }

        private String[] getMenuPath() {
            return this.path.substring(0, this.path.lastIndexOf("/")).split("/");
        }
    }
}

