package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.BorderLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.freehep.application.Application;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.gconsole.plugins.monitor.LsstMonitorPlugin;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;
import org.lsst.ccs.subsystem.monitor.data.MonitorState;

/**
 *
 * @author turri
 */
public class MonitorAssembly extends JPanel {

    private MonitorTrendingView table;
    private final MonitorPanel panel;
    private final CommandSender sender;
    
    public MonitorAssembly(CommandSender sender) {
        this.sender = sender;
        setLayout(new BorderLayout());

        try {
            LsstMonitorPlugin mp = (LsstMonitorPlugin) ((Studio) Application.getApplication()).getLookup().lookup(LsstMonitorPlugin.class);
            boolean useTree = (Boolean) mp.getServices().getProperty(LsstMonitorPlugin.DISPLAY_AS_TREE);
            if (useTree) {
                table = new MonitorTrendingTree(sender, null);
            } else {
                table = new MonitorTrendingTable(sender);
            }
        } catch (Exception x) {
            table = new MonitorTrendingTable(sender);
        }

        add((JComponent) table, BorderLayout.CENTER);
        panel = new MonitorPanel(sender);
        add(panel, BorderLayout.SOUTH);
    }

    public MonitorTrendingTable getTrendingTable() {
        try {
            return (MonitorTrendingTable) table;
        } catch (ClassCastException x) {
            remove((JComponent) table);
            table = new MonitorTrendingTable(sender);
            add((JComponent) table, BorderLayout.CENTER);
            return (MonitorTrendingTable) table;
        }
    }
    
    public MonitorPanel getControlPanel() {
        return panel;
    }
    
    public void setSubsystems(String... sNames) {
        table.setSubsystems(sNames);
        panel.setSubsystems(sNames);
    }
    
    public void handleData(String source, String key, Object o) {
        if (key.equals(MonitorState.KEY)) {
            MonitorState ms = (MonitorState) ((KeyValueData) o).getValue();
            table.updateTableState(source, ms);
            panel.updatePanel(source, areLimitsChanged(ms));
        } else if (o instanceof KeyValueDataList) {
            boolean trending = false;
            for (KeyValueData data : (KeyValueDataList) o) {
                if (data.getType() == KeyValueData.KeyValueDataType.KeyValueTrendingData) {
                    table.updateTableValue(source, data.getKey(), (Double) data.getValue());
                    trending = true;
                } else if (data.getType() == KeyValueData.KeyValueDataType.KeyValueMetaData) {
                    table.updateTableLimit(source, key, data.getKey(), (String) data.getValue());
                }
            }
            if (trending) {
                panel.updateTime();
            }
        }
    }

    public void updateTableModel(String sName, MonitorFullState status) {
        table.updateTableModel(sName, status);
        panel.updateTime();
        panel.updatePanel(sName, areLimitsChanged(status.getMonitorState()));
    }

    public void disableSystem(String sName) {
        table.disableSystem(sName);
        panel.disableSystem(sName);
    }

    private boolean areLimitsChanged(MonitorState status) {
        return !status.getLowLimitChange().isEmpty() | !status.getHighLimitChange().isEmpty();
    }

    private static final long serialVersionUID = 1L;
}
